/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.AuthenticatorStub;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.ProgramLogin;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletConfigStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpServletResponseStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class ProgramLoginTest
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(ProgramLoginTest.class);
    private static final String NEW_USER_URI = "new_user_uri";
    private static final String NEW_USER_NAME = "new_user";
    private static final String NEW_USER_PASSWORD = "new_user_pw";
    private static final UserAccount NEW_USER = ProgramLoginTest.createUserAccount("new_user_uri", "new_user", "new_user_pw", 0);
    private static final String OLD_USER_URI = "old_user_uri";
    private static final String OLD_USER_NAME = "old_user";
    private static final String OLD_USER_PASSWORD = "old_user_pw";
    private static final UserAccount OLD_USER = ProgramLoginTest.createUserAccount("old_user_uri", "old_user", "old_user_pw", 10);
    private AuthenticatorStub.Factory authenticatorFactory;
    private AuthenticatorStub authenticator;
    private ServletContextStub servletContext;
    private ServletConfigStub servletConfig;
    private HttpSessionStub session;
    private HttpServletRequestStub request;
    private HttpServletResponseStub response;
    private ProgramLogin servlet;

    @Before
    public void setLogging() {
    }

    @Before
    public void setup() throws Exception {
        this.authenticatorFactory = new AuthenticatorStub.Factory();
        this.authenticator = this.authenticatorFactory.getInstance(this.request);
        this.authenticator.addUser(NEW_USER);
        this.authenticator.addUser(OLD_USER);
        this.servletContext = new ServletContextStub();
        this.servletContext.setAttribute(AuthenticatorStub.FACTORY_ATTRIBUTE_NAME, this.authenticatorFactory);
        this.servletConfig = new ServletConfigStub();
        this.servletConfig.setServletContext(this.servletContext);
        this.servlet = new ProgramLogin();
        this.servlet.init((ServletConfig)this.servletConfig);
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.servletContext);
        this.request = new HttpServletRequestStub();
        this.request.setSession(this.session);
        this.request.setRequestUrl(new URL("http://this.that/vivo/programLogin"));
        this.request.setMethod("GET");
        this.response = new HttpServletResponseStub();
    }

    private static UserAccount createUserAccount(String uri, String name, String password, int loginCount) {
        UserAccount user = new UserAccount();
        user.setEmailAddress(name);
        user.setUri(uri);
        user.setPermissionSetUris(Collections.singleton("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        user.setArgon2Password(AuthenticatorStub.applyArgon2iEncodingStub(password));
        user.setMd5Password("");
        user.setLoginCount(loginCount);
        user.setPasswordChangeRequired(Boolean.valueOf(loginCount == 0));
        return user;
    }

    @After
    public void cleanup() {
        if (this.servlet != null) {
            this.servlet.destroy();
        }
    }

    @Test
    public void noUsername() {
        this.executeRequest(null, null, null);
        this.assert403();
    }

    @Test
    public void noPassword() {
        this.executeRequest(OLD_USER_NAME, null, null);
        this.assert403();
    }

    @Test
    public void unrecognizedUser() {
        this.executeRequest("bogusUsername", "bogusPassword", null);
        this.assert403();
    }

    @Test
    public void wrongPassword() {
        this.executeRequest(OLD_USER_NAME, "bogusPassword", null);
        this.assert403();
    }

    @Test
    public void success() {
        this.executeRequest(OLD_USER_NAME, OLD_USER_PASSWORD, null);
        this.assertSuccess();
    }

    @Test
    public void newPasswordNotNeeded() {
        this.executeRequest(OLD_USER_NAME, OLD_USER_PASSWORD, "unneededPW");
        this.assert403();
    }

    @Test
    public void newPasswordMissing() {
        this.executeRequest(NEW_USER_NAME, NEW_USER_PASSWORD, null);
        this.assert403();
    }

    @Test
    public void newPasswordTooLong() {
        this.executeRequest(NEW_USER_NAME, NEW_USER_PASSWORD, RandomStringUtils.randomAlphanumeric((int)65));
        this.assert403();
    }

    @Test
    public void newPasswordEqualsOldPassword() {
        this.executeRequest(NEW_USER_NAME, NEW_USER_PASSWORD, NEW_USER_PASSWORD);
        this.assert403();
    }

    @Test
    public void successWithNewPassword() {
        this.executeRequest(NEW_USER_NAME, NEW_USER_PASSWORD, "newerBetter");
        this.assertSuccess();
    }

    private void executeRequest(String email, String password, String newPassword) {
        if (email != null) {
            this.request.addParameter("email", email);
        }
        if (password != null) {
            this.request.addParameter("password", password);
        }
        if (newPassword != null) {
            this.request.addParameter("newPassword", newPassword);
        }
        try {
            this.servlet.doGet((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        }
        catch (IOException | ServletException e) {
            log.error((Object)e, e);
            Assert.fail((String)e.toString());
        }
    }

    private void assert403() {
        Assert.assertEquals((String)"status", (long)403L, (long)this.response.getStatus());
        log.debug((Object)("Message was '" + this.response.getErrorMessage() + "'"));
        Assert.assertEquals((String)"logged in", (Object)false, (Object)LoginStatusBean.getBean((HttpSession)this.session).isLoggedIn());
    }

    private void assertSuccess() {
        Assert.assertEquals((String)"status", (long)200L, (long)this.response.getStatus());
        Assert.assertEquals((String)"logged in", (Object)true, (Object)LoginStatusBean.getBean((HttpSession)this.session).isLoggedIn());
    }
}

