/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ShowDataPropertyHierarchyController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DatatypeDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ShowDataPropertyHierarchyControllerTest
extends ListControllerTestBase {
    private static final String PATH = "datapropEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String URI_GREATAUNT = "http://ont1/greatAunt";
    private static final String URI_GRANDMOTHER = "http://ont2/grandmother";
    private static final String URI_AUNT = "http://ont1/aunt";
    private static final String URI_MOTHER = "http://ont1/mother";
    private static final String URI_DAUGHTER = "http://ont2/daughter";
    private static final String NAME_GRANDMOTHER = "GrandMother";
    private static final String NAME_AUNT = "Aunt";
    private static final String NAME_MOTHER = "Mother";
    private static final String NAME_DAUGHTER = "Me";
    private static final String PICK_NAME_AUNT = "Old Aunt Agnes";
    private static final String PICK_NAME_MOTHER = "My Mother";
    private static final String DOMAIN_NONE = "http://domain/noSuchDomain";
    private static final String DOMAIN_NO_NAME = "http://domain/domainWithNoName";
    private static final String DOMAIN_W_NAME = "http://domain/namedDomain";
    private static final String NAME_DOMAIN = "An excellent domain";
    private static final String RANGE_NONE = "http://domain/noSuchRange";
    private static final String RANGE_NO_NAME = "http://domain/rangeWithNoName";
    private static final String RANGE_W_NAME = "http://domain/namedRange";
    private static final String NAME_RANGE = "Home on the range";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final ArrayNode NO_DATA_RESPONSE = ShowDataPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "nullfake", "ullfake", "ullfake", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_UNFILTERED = ShowDataPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont2/grandmother", "grandmother", "grandmother", "", "http://domain/noSuchRange", "unknown group", ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont1/mother", "My Mother", "My Mother", "namedDomain", "Home on the range", "The Groupsters", ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont2/daughter", "daughter", "daughter", "", "", "unspecified", new ObjectNode[0])), ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont1/aunt", "Old Aunt Agnes", "Old Aunt Agnes", "domainWithNoName", "", "", new ObjectNode[0])), ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont1/greatAunt", "greatAunt", "greatAunt", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT1 = ShowDataPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont1/greatAunt", "greatAunt", "greatAunt", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT2 = ShowDataPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont2/grandmother", "grandmother", "grandmother", "", "http://domain/noSuchRange", "unknown group", ShowDataPropertyHierarchyControllerTest.propertyHierarchyNode("datapropEdit", "http://ont2/daughter", "daughter", "daughter", "", "", "unspecified", new ObjectNode[0]))});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT3 = ShowDataPropertyHierarchyControllerTest.arrayOf(new JsonNode[0]);
    private ShowDataPropertyHierarchyController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private DatatypeDaoStub ddao;
    private DataPropertyDaoStub dpdao;
    private PropertyGroupDaoStub pgdao;
    private VClassDaoStub vcdao;

    @Before
    public void setup() {
        this.controller = new ShowDataPropertyHierarchyController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.ddao = new DatatypeDaoStub();
        this.dpdao = new DataPropertyDaoStub();
        this.pgdao = new PropertyGroupDaoStub();
        this.vcdao = new VClassDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setDatatypeDao(this.ddao);
        this.wadf.setDataPropertyDao(this.dpdao);
        this.wadf.setPropertyGroupDao(this.pgdao);
        this.wadf.setVClassDao(this.vcdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL, ModelAccess.ASSERTIONS_ONLY});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL, ModelAccess.LANGUAGE_NEUTRAL});
    }

    @Test
    public void noDataTest() throws Exception {
        String rawResponse = ShowDataPropertyHierarchyControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse + "]}";
        this.assertKlugedJson((JsonNode)NO_DATA_RESPONSE, kluged);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        ShowDataPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_UNFILTERED);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        ShowDataPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT1);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        ShowDataPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT2);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ShowDataPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.vcdao.setVClass(this.vclass(DOMAIN_NO_NAME, null));
        this.vcdao.setVClass(this.vclass(DOMAIN_W_NAME, NAME_DOMAIN));
        this.ddao.addDatatype(this.datatype(RANGE_NO_NAME, null));
        this.ddao.addDatatype(this.datatype(RANGE_W_NAME, NAME_RANGE));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_NO_NAME, null));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_W_NAME, NAME_GROUP));
        this.dpdao.addDataProperty(this.dataProperty(URI_GREATAUNT, null, null, null, null, null));
        this.dpdao.addDataProperty(this.dataProperty(URI_GRANDMOTHER, NAME_GRANDMOTHER, null, DOMAIN_NONE, RANGE_NONE, GROUP_NONE));
        this.dpdao.addDataProperty(this.dataProperty(URI_AUNT, NAME_AUNT, PICK_NAME_AUNT, DOMAIN_NO_NAME, RANGE_NO_NAME, GROUP_NO_NAME), URI_GRANDMOTHER);
        this.dpdao.addDataProperty(this.dataProperty(URI_MOTHER, NAME_MOTHER, PICK_NAME_MOTHER, DOMAIN_W_NAME, RANGE_W_NAME, GROUP_W_NAME), URI_GRANDMOTHER);
        this.dpdao.addDataProperty(this.dataProperty(URI_DAUGHTER, NAME_DAUGHTER, null, null, null, null), URI_MOTHER);
    }

    private DataProperty dataProperty(String uri, String name, String pickListName, String domainClassUri, String rangeDatatypeUri, String groupUri) {
        DataProperty dp = new DataProperty();
        dp.setURI(uri);
        dp.setName(name);
        dp.setPickListName(pickListName);
        dp.setDomainClassURI(domainClassUri);
        dp.setRangeDatatypeURI(rangeDatatypeUri);
        dp.setGroupURI(groupUri);
        return dp;
    }

    private Datatype datatype(String uri, String name) {
        Datatype d = new Datatype();
        d.setUri(uri);
        d.setName(name);
        return d;
    }

    private PropertyGroup propertyGroup(String uri, String name) {
        PropertyGroup pg = new PropertyGroup();
        pg.setURI(uri);
        pg.setName(name);
        return pg;
    }

    private VClass vclass(String uri) {
        VClass vc = new VClass();
        vc.setURI(uri);
        return vc;
    }

    private VClass vclass(String uri, String name) {
        VClass vc = this.vclass(uri);
        vc.setName(name);
        return vc;
    }
}

