/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.jena.MenuDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.menu.MainMenu;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.menu.MenuItem;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MenuDaoJenaTest
extends AbstractTestClass {
    OntModel displayModel;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        MenuDaoJenaTest.setLoggerLevel(RDFDefaultErrorHandler.class, Level.OFF);
        Model model = ModelFactory.createDefaultModel();
        InputStream in = MenuDaoJenaTest.class.getResourceAsStream("resources/menuForTest.n3");
        model.read(in, "", "N3");
        this.displayModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
    }

    @Test
    public void getMenuItemTest() {
        SimpleOntModelSelector sos = new SimpleOntModelSelector(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM));
        sos.setDisplayModel(this.displayModel);
        MenuDaoJena menuDaoJena = new MenuDaoJena(new WebappDaoFactoryJena((OntModelSelector)sos));
        MainMenu menu = menuDaoJena.getMainMenu("notImportant");
        try {
            Class<UrlBuilder> clz = UrlBuilder.class;
            Field f = clz.getDeclaredField("contextPath");
            f.setAccessible(true);
            f.set(null, "bogusUrlContextPath");
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertNotNull((Object)menu);
        Assert.assertNotNull((Object)menu.getItems());
        Assert.assertEquals((long)5L, (long)menu.getItems().size());
        MenuItem item = (MenuItem)menu.getItems().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"Home", (Object)item.getLinkText());
        Assert.assertEquals((Object)"bogusUrlContextPath/home", (Object)item.getUrl());
        item = (MenuItem)menu.getItems().get(1);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"People", (Object)item.getLinkText());
        Assert.assertEquals((Object)"bogusUrlContextPath/people", (Object)item.getUrl());
        item = (MenuItem)menu.getItems().get(2);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"Publications", (Object)item.getLinkText());
        Assert.assertEquals((Object)"bogusUrlContextPath/publications", (Object)item.getUrl());
        item = (MenuItem)menu.getItems().get(3);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"Events", (Object)item.getLinkText());
        Assert.assertEquals((Object)"bogusUrlContextPath/events", (Object)item.getUrl());
        item = (MenuItem)menu.getItems().get(4);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"Organizations", (Object)item.getLinkText());
        Assert.assertEquals((Object)"bogusUrlContextPath/organizations", (Object)item.getUrl());
    }

    @Test
    public void isActiveTest() {
        SimpleOntModelSelector sos = new SimpleOntModelSelector(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM));
        sos.setDisplayModel(this.displayModel);
        MenuDaoJena menuDaoJena = new MenuDaoJena(new WebappDaoFactoryJena((OntModelSelector)sos));
        Assert.assertTrue((boolean)menuDaoJena.isActive("/", "/"));
        Assert.assertTrue((boolean)menuDaoJena.isActive("/people", "/people"));
        Assert.assertFalse((boolean)menuDaoJena.isActive("/people", "/"));
        Assert.assertFalse((boolean)menuDaoJena.isActive("/", "/people"));
    }
}

