/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BasicValidationVTwo;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.i18n.I18nStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class BasicValidationVTwoTest {
    @Before
    public void useI18nStubBundles() {
        I18nStub.setup();
    }

    @Test
    public void testHttpUrlValidate() {
        HttpServletRequestStub req = new HttpServletRequestStub();
        BasicValidationVTwo bv = new BasicValidationVTwo(Collections.EMPTY_MAP, I18nStub.bundle((HttpServletRequest)req));
        String res = bv.validate("httpUrl", "http://example.com/index");
        Assert.assertEquals((Object)BasicValidationVTwo.SUCCESS, (Object)res);
        res = bv.validate("httpUrl", "http://example.com/index?bogus=skjd%20skljd&something=sdkf");
        Assert.assertEquals((Object)BasicValidationVTwo.SUCCESS, (Object)res);
        res = bv.validate("httpUrl", "http://example.com/index#2.23?bogus=skjd%20skljd&something=sdkf");
        Assert.assertEquals((Object)BasicValidationVTwo.SUCCESS, (Object)res);
    }

    @Test
    public void testEmptyValidate() {
        HttpServletRequestStub req = new HttpServletRequestStub();
        BasicValidationVTwo bv = new BasicValidationVTwo(Collections.EMPTY_MAP, I18nStub.bundle((HttpServletRequest)req));
        Assert.assertEquals((Object)"required_field_empty_msg", (Object)bv.validate("nonempty", null));
        Assert.assertEquals((Object)"required_field_empty_msg", (Object)bv.validate("nonempty", ""));
        Assert.assertEquals((Object)BasicValidationVTwo.SUCCESS, (Object)bv.validate("nonempty", "some value"));
    }
}

