/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.freemarker.loader;

import edu.cornell.mannlib.vitro.webapp.freemarker.loader.FreemarkerTemplateLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class FreemarkerTemplateLoaderTest {
    private FreemarkerTemplateLoader.PathPiecesFileVisitor visitor;
    private String[] paths;
    public static final String[] FREEMARKER_TEST_PATHS = new String[]{"long/this_fr_BE.ftl", "language_fr.ftl", "default.ftl", "language-approx_en_US.ftl"};

    @Test
    public void ppLanguageRegionExtension() {
        this.assertPathPieces("this_en_US.ftl", "this", "_en", "_US", ".ftl");
    }

    @Test
    public void ppLanguageRegion() {
        this.assertPathPieces("this_en_US", "this", "_en", "_US", "");
    }

    @Test
    public void ppLanguageExtension() {
        this.assertPathPieces("this_en.ftl", "this", "_en", "", ".ftl");
    }

    @Test
    public void ppLanguage() {
        this.assertPathPieces("this_en", "this", "_en", "", "");
    }

    @Test
    public void ppDefaultExtension() {
        this.assertPathPieces("this.ftl", "this", "", "", ".ftl");
    }

    @Test
    public void ppDefault() {
        this.assertPathPieces("this", "this", "", "", "");
    }

    @Test
    public void ppExtraUnderscoreExtension() {
        this.assertPathPieces("woo_hoo_en_US.ftl", "woo_hoo", "_en", "_US", ".ftl");
    }

    @Test
    public void ppExtraUnderscore() {
        this.assertPathPieces("woo_hoo_en_US", "woo_hoo", "_en", "_US", "");
    }

    @Test
    public void baseAndExtensionMatch() {
        this.paths("match-me.ftl");
        this.assertMatches("match-me.ftl", 1, "match-me.ftl");
    }

    @Test
    public void baseAndExtensionDontMatch() {
        this.paths("match-me.ftl");
        this.assertMatches("fail.ftl", 0, null);
        this.assertMatches("match-me", 0, null);
        this.assertMatches("match-me.FTL", 0, null);
    }

    @Test
    public void matchRegardlessOfDepth() {
        this.paths("short-path.ftl", "long/long-path.ftl");
        this.assertMatches("long/short-path.ftl", 1, "short-path.ftl");
        this.assertMatches("long-path.ftl", 1, "long/long-path.ftl");
    }

    @Test
    public void preferShorterPath() {
        this.paths("shorter-is-better", "long/shorter-is-better");
        this.assertMatches("shorter-is-better", 2, "shorter-is-better");
    }

    @Test
    public void preferShorterPathToExactPath() {
        this.paths("shorter-is-better", "long/shorter-is-better");
        this.assertMatches("long/shorter-is-better", 2, "shorter-is-better");
    }

    @Test
    public void languageAndRegionMustMatchExactly() {
        this.paths("this_es_MX.ftl", "this_es_ES.ftl", "this_es.ftl");
        this.assertMatches("this_es_ES.ftl", 1, "this_es_ES.ftl");
    }

    @Test
    public void languageAndRegionNoMatch() {
        this.paths("this_es_MX.ftl", "this_es_ES.ftl", "this_es.ftl");
        this.assertMatches("this_es_GO.ftl", 0, null);
    }

    @Test
    public void languagePrefersExactMatch() {
        this.paths("this_es_MX.ftl", "this_es.ftl", "this_es_ES.ftl");
        this.assertMatches("this_es.ftl", 3, "this_es.ftl");
    }

    @Test
    public void languageAcceptsApproximateMatch() {
        this.paths("this_es_MX.ftl");
        this.assertMatches("this_es.ftl", 1, "this_es_MX.ftl");
    }

    @Test
    public void languagePrefersApproximateAlphabetical() {
        this.paths("this_es_MX.ftl", "this_es_ES.ftl");
        this.assertMatches("this_es.ftl", 2, "this_es_ES.ftl");
    }

    @Test
    public void defaultPrefersExactMatch() {
        this.paths("this_fr.ftl", "this.ftl", "this_fr_BE.ftl");
        this.assertMatches("this.ftl", 3, "this.ftl");
    }

    @Test
    public void defaultPrefersDefaultRegion() {
        this.paths("this_fr_BE.ftl", "this_fr.ftl", "this_fr_CA.ftl");
        this.assertMatches("this.ftl", 3, "this_fr.ftl");
    }

    @Test
    public void defaultPrefersLanguageAlphabetical() {
        this.paths("this_es.ftl", "this_fr.ftl");
        this.assertMatches("this.ftl", 2, "this_es.ftl");
    }

    @Test
    public void defaultPrefersRegionAlphabetical() {
        this.paths("this_fr_BE.ftl", "this_fr_CA.ftl");
        this.assertMatches("this.ftl", 2, "this_fr_BE.ftl");
    }

    @Test
    public void freemarkerLangAndRegionExact() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("this_fr_BE.ftl", 1, "long/this_fr_BE.ftl");
    }

    @Test
    public void freemarkerLangAndRegionMatchLang() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("language_fr_CA.ftl", 2, "language_fr.ftl");
    }

    @Test
    public void freemarkerLangAndRegionMatchDefault() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("default_es_ES.ftl", 3, "default.ftl");
    }

    @Test
    public void freemarkerLangAndRegionNoMatch() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("bogus_en_US.ftl", 3, null);
    }

    @Test
    public void freemarkerLangExact() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("language_fr.ftl", 1, "language_fr.ftl");
    }

    @Test
    public void freemarkerLangMatchLangAndRegion() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("language-approx_en.ftl", 1, "language-approx_en_US.ftl");
    }

    @Test
    public void freemarkerLangMatchDefault() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("default_en.ftl", 2, "default.ftl");
    }

    @Test
    public void freemarkerLangNoMatch() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("bogus_it.ftl", 2, null);
    }

    @Test
    public void freemarkerDefaultExact() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("default.ftl", 1, "default.ftl");
    }

    @Test
    public void freemarkerDefaultMatchLang() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("language.ftl", 1, "language_fr.ftl");
    }

    @Test
    public void freemarkerDefaultMatchLangAndRegion() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("this.ftl", 1, "long/this_fr_BE.ftl");
    }

    @Test
    public void freemarkerDefaultNoMatch() {
        this.paths = FREEMARKER_TEST_PATHS;
        this.assertFM("bogus.ftl", 1, null);
    }

    private void paths(String ... p) {
        this.paths = p;
    }

    private void assertPathPieces(String path, String base, String language, String region, String extension) {
        FreemarkerTemplateLoader.PathPieces pp = new FreemarkerTemplateLoader.PathPieces(path);
        String[] expected = new String[]{base, language, region, extension};
        String[] actual = new String[]{pp.base, pp.language, pp.region, pp.extension};
        Assert.assertEquals((String)"pieces", Arrays.asList(expected), Arrays.asList(actual));
    }

    private void assertMatches(String searchTerm, int expectedHowMany, String expectedBestFitString) {
        Path actualBestFit;
        Path expectedBestFit = expectedBestFitString == null ? null : Paths.get(expectedBestFitString, new String[0]);
        SortedSet<FreemarkerTemplateLoader.PathPieces> matches = this.runTheVisitor(searchTerm);
        int actualHowMany = matches.size();
        Path path = actualBestFit = matches.isEmpty() ? null : matches.last().path;
        if (expectedHowMany != actualHowMany) {
            Assert.fail((String)("How many results: expected " + expectedHowMany + ", but was  " + actualHowMany + ": " + matches));
        }
        Assert.assertEquals((String)"Best result", (Object)expectedBestFit, (Object)actualBestFit);
    }

    private void assertFM(String searchTerm, int expectedNumberOfTries, String expectedBestString) {
        SortedSet<FreemarkerTemplateLoader.PathPieces> matches;
        Path expectedBestFit = expectedBestString == null ? null : Paths.get(expectedBestString, new String[0]);
        FreemarkerTemplateLoader.PathPieces stPp = new FreemarkerTemplateLoader.PathPieces(searchTerm);
        int actualNumberOfTries = 0;
        Path actualBestFit = null;
        if (StringUtils.isNotBlank((CharSequence)stPp.region)) {
            ++actualNumberOfTries;
            matches = this.runTheVisitor(stPp.base + stPp.language + stPp.region + stPp.extension);
            if (!matches.isEmpty()) {
                actualBestFit = matches.last().path;
            }
        }
        if (actualBestFit == null && StringUtils.isNotBlank((CharSequence)stPp.language)) {
            ++actualNumberOfTries;
            matches = this.runTheVisitor(stPp.base + stPp.language + stPp.extension);
            if (!matches.isEmpty()) {
                actualBestFit = matches.last().path;
            }
        }
        if (actualBestFit == null) {
            ++actualNumberOfTries;
            matches = this.runTheVisitor(stPp.base + stPp.extension);
            if (!matches.isEmpty()) {
                actualBestFit = matches.last().path;
            }
        }
        Assert.assertEquals((String)"How many tries", (long)expectedNumberOfTries, (long)actualNumberOfTries);
        Assert.assertEquals((String)"best fit", (Object)expectedBestFit, actualBestFit);
    }

    private SortedSet<FreemarkerTemplateLoader.PathPieces> runTheVisitor(String searchTerm) {
        try {
            this.visitor = new PathPiecesFileVisitorStub(new FreemarkerTemplateLoader.PathPieces(searchTerm));
            for (String p : this.paths) {
                this.visitor.visitFile(Paths.get(p, new String[0]), null);
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Failed: " + e));
        }
        return this.visitor.getMatches();
    }

    private static class PathPiecesFileVisitorStub
    extends FreemarkerTemplateLoader.PathPiecesFileVisitor {
        public PathPiecesFileVisitorStub(FreemarkerTemplateLoader.PathPieces searchTerm) {
            super(searchTerm);
        }

        public boolean fileQualifies(Path path) {
            return true;
        }
    }
}

