/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.i18n.TranslationProvider;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class TranslationProviderTest {
    private static final String VITRO = "Vitro";
    private static final String VIVO = "VIVO";
    private static final String ROOT = "src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationProviderTest/";
    private static final String TRANSLATIONS_N3_FILE = "src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationProviderTest/modelInitContent.n3";
    private static final String WILMA = "wilma";
    private static final String NEMO = "nemo";
    private Model i18nModel;
    private RDFServiceModel rdfService;
    private TranslationProvider tp;

    public void init(String i18nFile, String themeName, String appName) throws FileNotFoundException {
        this.i18nModel = ModelFactory.createDefaultModel();
        this.i18nModel.read((Reader)new FileReader(new File(i18nFile)), null, "n3");
        Dataset ds = DatasetFactory.createTxnMem();
        ds.addNamedModel("http://vitro.mannlib.cornell.edu/default/interface-i18n", this.i18nModel);
        this.rdfService = new RDFServiceModel(ds);
        this.tp = TranslationProvider.getInstance();
        this.tp.rdfService = this.rdfService;
        this.tp.setTheme(themeName);
        this.tp.application = appName;
        this.tp.clearCache();
    }

    @Test
    public void testNotExistingKey() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "non_existing_key", array);
        Assert.assertEquals((Object)"ERROR: Translation not found 'non_existing_key'", (Object)translation);
    }

    @Test
    public void testVitroWilmaEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro wilma en-US", (Object)translation);
    }

    @Test
    public void testVitroWilmaDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro wilma de-DE", (Object)translation);
    }

    @Test
    public void testVIVOWilmaEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey VIVO wilma en-US", (Object)translation);
    }

    @Test
    public void testVIVOWilmaDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey", array);
        Assert.assertEquals((Object)"testkey VIVO wilma de-DE", (Object)translation);
    }

    @Test
    public void testThemeFallbackVitroNemoEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro no theme en-US", (Object)translation);
    }

    @Test
    public void testThemeFallbackVitroNemoDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro no theme de-DE", (Object)translation);
    }

    @Test
    public void testThemeFallbackVIVONemoEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey VIVO no theme en-US", (Object)translation);
    }

    @Test
    public void testThemeFallbackVIVONemoDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey", array);
        Assert.assertEquals((Object)"testkey VIVO no theme de-DE", (Object)translation);
    }

    @Test
    public void testAppFallbackVIVONemoEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey_app_fallback", array);
        Assert.assertEquals((Object)"testkey_app_fallback Vitro wilma en-US", (Object)translation);
    }

    @Test
    public void testAppFallbackVIVONemoDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey_app_fallback", array);
        Assert.assertEquals((Object)"testkey_app_fallback Vitro wilma de-DE", (Object)translation);
    }

    @Test
    public void testAppAndThemeFallbackVIVONemoEnUS() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey_app_fallback", array);
        Assert.assertEquals((Object)"testkey_app_fallback Vitro no theme en-US", (Object)translation);
    }

    @Test
    public void testAppAndThemeFallbackVIVONemoDeDE() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, NEMO, VIVO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("de-DE"), "testkey_app_fallback", array);
        Assert.assertEquals((Object)"testkey_app_fallback Vitro no theme de-DE", (Object)translation);
    }

    @Test
    public void testCache() throws FileNotFoundException {
        this.init(TRANSLATIONS_N3_FILE, WILMA, VITRO);
        Object[] array = new Object[]{};
        String translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro wilma en-US", (Object)translation);
        this.tp.application = VIVO;
        translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey Vitro wilma en-US", (Object)translation);
        this.tp.clearCache();
        translation = this.tp.getTranslation(Collections.singletonList("en-US"), "testkey", array);
        Assert.assertEquals((Object)"testkey VIVO wilma en-US", (Object)translation);
    }
}

