/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.junit.Before;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class ConfigurationBeanLoaderTestBase
extends AbstractTestClass {
    protected static final String GENERIC_INSTANCE_URI = "http://mytest.edu/some_instance";
    protected static final String GENERIC_PROPERTY_URI = "http://mytest.edu/some_property";
    protected static final String SIMPLE_SUCCESS_INSTANCE_URI = "http://mytest.edu/simple_success_instance";
    protected static final String FULL_SUCCESS_INSTANCE_URI = "http://mytest.edu/full_success_instance";
    protected static final String FULL_SUCCESS_BOOST_PROPERTY = "http://mydomain.edu/hasBoost";
    protected static final String FULL_SUCCESS_TEXT_PROPERTY = "http://mydomain.edu/hasText";
    protected static final String FULL_SUCCESS_HELPER_PROPERTY = "http://mydomain.edu/hasHelper";
    protected static final String FULL_SUCCESS_HELPER_INSTANCE_URI = "http://mytest.edu/full_success_helper_instance";
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    protected Model model;
    protected ConfigurationBeanLoader loader;
    protected ConfigurationBeanLoader noRequestLoader;
    protected ConfigurationBeanLoader noContextLoader;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        ModelAccessFactoryStub maf = new ModelAccessFactoryStub();
        this.model = ModelUtilitiesTestHelper.model(new Statement[0]);
        this.loader = new ConfigurationBeanLoader(this.model, (HttpServletRequest)this.req);
        this.noRequestLoader = new ConfigurationBeanLoader(this.model, (ServletContext)this.ctx);
        this.noContextLoader = new ConfigurationBeanLoader(this.model);
    }

    protected void expectSimpleFailure(Class<?> failureClass, ExpectedThrowable expected, ExpectedThrowable cause) throws ConfigurationBeanLoaderException {
        this.expectException(expected.getClazz(), expected.getMessageSubstring(), cause.getClazz(), cause.getMessageSubstring());
        Object unused = this.loader.loadInstance(GENERIC_INSTANCE_URI, failureClass);
    }

    protected ExpectedThrowable throwable(Class<? extends Throwable> clazz, String messageSubstring) {
        return new ExpectedThrowable(clazz, messageSubstring);
    }

    private static class ExpectedThrowable {
        private final Class<? extends Throwable> clazz;
        private final String messageSubstring;

        public ExpectedThrowable(Class<? extends Throwable> clazz, String messageSubstring) {
            this.clazz = clazz;
            this.messageSubstring = messageSubstring;
        }

        public Class<? extends Throwable> getClazz() {
            return this.clazz;
        }

        public String getMessageSubstring() {
            return this.messageSubstring;
        }
    }
}

