/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderTestBase;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationBeanLoader_ValidationTest
extends ConfigurationBeanLoaderTestBase {
    @Test
    public void validationMethodHasParameters_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ValidationMethodWithParameter.class)));
        this.expectSimpleFailure(ValidationMethodWithParameter.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should not have parameters"));
    }

    @Test
    public void validationMethodDoesNotReturnVoid_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ValidationMethodShouldReturnVoid.class)));
        this.expectSimpleFailure(ValidationMethodShouldReturnVoid.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should return void"));
    }

    @Test
    public void validationMethodNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ValidationMethodIsPrivate.class)));
        this.expectSimpleFailure(ValidationMethodIsPrivate.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ValidationFailedException.class, "Error executing validation method"));
    }

    @Test
    public void validationMethodThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ValidationThrowsException.class)));
        this.expectSimpleFailure(ValidationThrowsException.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ValidationFailedException.class, "Error executing validation method"));
    }

    @Test
    public void superclassContainsValidationMethod_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(EmptyValidationSubclass.class)));
        EmptyValidationSubclass instance = (EmptyValidationSubclass)this.loader.loadInstance("http://mytest.edu/some_instance", EmptyValidationSubclass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)instance.validatorSuperHasRun);
    }

    @Test
    public void superclassAndSubclassContainValidationMethods_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(AdditionalValidationSubclass.class)));
        AdditionalValidationSubclass instance = (AdditionalValidationSubclass)this.loader.loadInstance("http://mytest.edu/some_instance", AdditionalValidationSubclass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)instance.validatorSuperHasRun);
        Assert.assertTrue((boolean)instance.validatorSubHasRun);
    }

    @Test
    public void validationMethodOverridesValidationMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ValidationOverValidationSubclass.class)));
        this.expectSimpleFailure(ValidationOverValidationSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "overrides a validation method"));
    }

    @Test
    public void plainMethodOverridesValidationMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PlainOverValidationSubclass.class)));
        this.expectSimpleFailure(PlainOverValidationSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "overrides a validation method"));
    }

    public static class PlainOverValidationSubclass
    extends ValidationSuperclass {
        @Override
        public void validatorSuper() {
        }
    }

    public static class ValidationOverValidationSubclass
    extends EmptyValidationSubclass {
        @Override
        @Validation
        public void validatorSuper() {
        }
    }

    public static class AdditionalValidationSubclass
    extends ValidationSuperclass {
        public boolean validatorSubHasRun = false;

        @Validation
        public void validatorSub() {
            if (this.validatorSubHasRun) {
                throw new RuntimeException("validatorSub has already run.");
            }
            this.validatorSubHasRun = true;
        }
    }

    public static class EmptyValidationSubclass
    extends ValidationSuperclass {
    }

    public static class ValidationSuperclass {
        public boolean validatorSuperHasRun = false;

        @Validation
        public void validatorSuper() {
            if (this.validatorSuperHasRun) {
                throw new RuntimeException("validatorSuper has already run.");
            }
            this.validatorSuperHasRun = true;
        }
    }

    public static class ValidationThrowsException {
        @Validation
        public void validateFails() {
            throw new RuntimeException("from validation method");
        }
    }

    public static class ValidationMethodIsPrivate {
        @Validation
        private void validateIsPrivate() {
        }
    }

    public static class ValidationMethodShouldReturnVoid {
        @Validation
        public String validateWithReturnType() {
            return "Hi there!";
        }
    }

    public static class ValidationMethodWithParameter {
        @Validation
        public void validateWithParameter(String s) {
        }
    }
}

