/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SparqlQueryDataGetter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.vocabulary.RDF;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class SparqlQueryDataGetterTest
extends AbstractTestClass {
    OntModel displayModel;
    String testDataGetterURI_1 = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query1data";
    WebappDaoFactory wdf;
    VitroRequest vreq;

    @Override
    @Before
    public void setUp() {
        SparqlQueryDataGetterTest.setLoggerLevel(RDFDefaultErrorHandler.class, Level.OFF);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        InputStream in = SparqlQueryDataGetterTest.class.getResourceAsStream("resources/dataGetterTest.n3");
        model.read(in, "", "N3");
        this.displayModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        SimpleOntModelSelector sos = new SimpleOntModelSelector(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM));
        sos.setDisplayModel(this.displayModel);
        this.wdf = new WebappDaoFactoryJena((OntModelSelector)sos);
        this.vreq = new VitroRequest((HttpServletRequest)new HttpServletRequestStub());
    }

    @Test
    public void testBasicGetData() throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        DataGetter dg = DataGetterUtils.dataGetterForURI((VitroRequest)this.vreq, (Model)this.displayModel, (String)this.testDataGetterURI_1);
        Assert.assertNotNull((Object)dg);
        Assert.assertTrue((String)("DataGetter should be of type " + SparqlQueryDataGetter.class.getName()), (boolean)(dg instanceof SparqlQueryDataGetter));
        SparqlQueryDataGetter sdg = (SparqlQueryDataGetter)dg;
        Model dataModel = ModelFactory.createDefaultModel();
        String bobURI = "http://example.com/p/bob";
        dataModel.add(ResourceFactory.createResource((String)bobURI), RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://xmlns.com/foaf/0.1/Person"));
        Map params = Collections.emptyMap();
        Map mapOut = sdg.doQueryOnModel(sdg.queryText, dataModel);
        Assert.assertNotNull((Object)mapOut);
        Assert.assertTrue((String)"should contain key people", (boolean)mapOut.containsKey("people"));
        Object obj = mapOut.get("people");
        Assert.assertTrue((String)("people should be a List, it is " + obj.getClass().getName()), (boolean)(obj instanceof List));
        List people = (List)obj;
        Assert.assertEquals((long)1L, (long)people.size());
        Map first = (Map)people.get(0);
        Assert.assertEquals((Object)bobURI, first.get("uri"));
    }
}

