/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.json;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JacksonUtilsTest
extends AbstractTestClass {
    @Test
    public void quoteNull() {
        this.assertJacksonQuoted(null, "");
    }

    @Test
    public void quoteQuote() {
        this.assertJacksonQuoted("\"", "\\\"");
    }

    @Test
    public void quoteBackslash() {
        this.assertJacksonQuoted("\\", "\\\\");
    }

    @Test
    public void quoteReturn() {
        this.assertJacksonQuoted("\r", "\\r");
    }

    @Test
    public void quoteUnicode() {
        this.assertJacksonQuoted("\u0007", "\\u0007");
    }

    @Test
    public void quoteAssorted() {
        this.assertJacksonQuoted("\n\b\f\t", "\\n\\b\\f\\t");
    }

    private void assertJacksonQuoted(String raw, String expected) {
        String actual = JacksonUtils.quote((String)raw);
        Assert.assertEquals((Object)("\"" + expected + "\""), (Object)actual);
    }
}

