/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.rdf.model.Model;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SparqlQueryRunnerTest
extends AbstractTestClass {
    private static final String SUBJECT_URI = "http://namespace/subject_uri";
    private static final String PREDICATE_URI = "http://namespace/predicate_uri";
    private static final String OBJECT_VALUE = "object_value";
    private static final String SELECT_QUERY = "SELECT ?s ?p ?o WHERE { ?s ?p ?o . }";
    private static final JsonObject EXPECTED_SELECT_RESULTS = JSON.parse((String)"{    'head' : {      'vars' : [ 's', 'p', 'o' ]    } ,   'results' : {      'bindings' : [        {          'p' : {            'type' : 'uri' ,            'value' : 'http://namespace/predicate_uri'          } ,         'o' : {            'type' : 'literal' ,            'value' : 'object_value'          } ,         's' : {            'type' : 'uri' ,            'value' : 'http://namespace/subject_uri'          }       }      ]    } } ");
    private static final String CONSTRUCT_QUERY = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private Model model;
    private RDFService rdfService;
    private ByteArrayOutputStream buffer;
    private Model constructed;

    @Before
    public void setup() {
        this.model = ModelUtilitiesTestHelper.model(ModelUtilitiesTestHelper.dataProperty(SUBJECT_URI, PREDICATE_URI, OBJECT_VALUE));
        this.rdfService = new RDFServiceModel(this.model);
        this.buffer = new ByteArrayOutputStream();
    }

    @Test
    public void selectQueryAgainstModel() {
        SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().writeToOutput((OutputStream)this.buffer);
        this.assertExpectedSelectResults();
    }

    @Test
    public void selectQueryHolderAgainstModel() {
        SparqlQueryRunner.createSelectQueryContext((Model)this.model, (QueryHolder)SparqlQueryRunner.queryHolder((String)SELECT_QUERY)).execute().writeToOutput((OutputStream)this.buffer);
        this.assertExpectedSelectResults();
    }

    @Test
    public void selectQueryAgainstRDFService() {
        SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (String)SELECT_QUERY).execute().writeToOutput((OutputStream)this.buffer);
        this.assertExpectedSelectResults();
    }

    @Test
    public void selectQueryHolderAgainstRDFService() {
        SparqlQueryRunner.createSelectQueryContext((RDFService)this.rdfService, (QueryHolder)SparqlQueryRunner.queryHolder((String)SELECT_QUERY)).execute().writeToOutput((OutputStream)this.buffer);
        this.assertExpectedSelectResults();
    }

    @Test
    public void selectToStringFields() {
        List objectValues = SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().toStringFields(new String[]{"o"}).flatten();
        Assert.assertEquals(Arrays.asList(OBJECT_VALUE), (Object)objectValues);
    }

    @Test
    public void constructQueryAgainstModel() {
        this.constructed = SparqlQueryRunner.createConstructQueryContext((Model)this.model, (String)CONSTRUCT_QUERY).execute().toModel();
        this.assertExpectedConstructResults();
    }

    @Test
    public void constructQueryHolderAgainstModel() {
        this.constructed = SparqlQueryRunner.createConstructQueryContext((Model)this.model, (QueryHolder)SparqlQueryRunner.queryHolder((String)CONSTRUCT_QUERY)).execute().toModel();
        this.assertExpectedConstructResults();
    }

    @Test
    public void constructQueryAgainstRDFService() {
        this.constructed = SparqlQueryRunner.createConstructQueryContext((RDFService)this.rdfService, (String)CONSTRUCT_QUERY).execute().toModel();
        this.assertExpectedConstructResults();
    }

    @Test
    public void constructQueryHolderAgainstRDFService() {
        this.constructed = SparqlQueryRunner.createConstructQueryContext((RDFService)this.rdfService, (QueryHolder)SparqlQueryRunner.queryHolder((String)CONSTRUCT_QUERY)).execute().toModel();
        this.assertExpectedConstructResults();
    }

    private void assertExpectedSelectResults() {
        try {
            JsonObject actual = JSON.parse((String)this.buffer.toString("UTF-8"));
            Assert.assertEquals((Object)EXPECTED_SELECT_RESULTS, (Object)actual);
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.toString());
        }
    }

    private void assertExpectedConstructResults() {
        Assert.assertEquals((Object)this.model.listStatements().toSet(), (Object)this.constructed.listStatements().toSet());
    }
}

