/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.PropertyListConfig;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.CollatedObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DefaultObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.freemarker.cache.TemplateLoaderStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class ObjectPropertyTemplateModel_PropertyListConfigTest
extends AbstractTestClass {
    private static File configDir;
    private ObjectPropertyTemplateModel optm;
    private ObjectProperty op;
    private WebappDaoFactoryStub wadf;
    private ObjectPropertyDaoStub opDao;
    private FauxPropertyDaoStub fpDao;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub hreq;
    private VitroRequest vreq;
    private IndividualImpl subject;
    private TemplateLoaderStub tl;
    private StringWriter logMessages;
    private ModelAccessFactoryStub mafs;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void createConfigFiles() throws IOException {
        configDir = ObjectPropertyTemplateModel_PropertyListConfigTest.createTempDirectory("configDir");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("constructQueryMissing");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("constructQueryMultiple");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("default");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorClassNotFound");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorClassNotSuitable");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorConstructorThrowsException");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorNameEmpty");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorOK");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("postProcessorWrongConstructor");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("selectQueryCollatedValid");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("selectQueryCollatedNoSelect");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("selectQueryCollatedNoOrder");
        ObjectPropertyTemplateModel_PropertyListConfigTest.createConfigFile("templateDoesNotExist");
    }

    private static void createConfigFile(String shortName) throws IOException {
        String fullName = "testConfig-" + shortName + ".xml";
        Class<ObjectPropertyTemplateModel_PropertyListConfigTest> clazz = ObjectPropertyTemplateModel_PropertyListConfigTest.class;
        String contents = ObjectPropertyTemplateModel_PropertyListConfigTest.readAll(clazz.getResourceAsStream(fullName));
        ObjectPropertyTemplateModel_PropertyListConfigTest.createFile(configDir, fullName, contents);
    }

    @Before
    public void setup() {
        this.logMessages = new StringWriter();
        this.opDao = new ObjectPropertyDaoStub();
        this.fpDao = new FauxPropertyDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setObjectPropertyDao(this.opDao);
        this.wadf.setFauxPropertyDao(this.fpDao);
        this.ctx = new ServletContextStub();
        this.ctx.setRealPaths("/config/", configDir);
        this.ctx.setRealPath("/config/listViewConfig-default.xml", this.ctx.getRealPath("/config/testConfig-default.xml"));
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.hreq = new HttpServletRequestStub();
        this.hreq.setSession(this.session);
        this.vreq = new VitroRequest((HttpServletRequest)this.hreq);
        this.mafs = new ModelAccessFactoryStub();
        this.mafs.get((HttpServletRequest)this.vreq).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.ReasoningOption.ASSERTIONS_AND_INFERENCES});
        this.mafs.get((HttpServletRequest)this.vreq).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
        this.subject = new IndividualImpl();
        this.tl = new TemplateLoaderStub();
        this.tl.createTemplate("propStatement-default.ftl", "");
    }

    @AfterClass
    public static void cleanup() {
        if (configDir != null) {
            ObjectPropertyTemplateModel_PropertyListConfigTest.purgeDirectoryRecursively(configDir);
        }
    }

    @Test(expected=NullPointerException.class)
    public void operationIsNull() throws InvalidConfigurationException {
        this.optm = new NonCollatingOPTM(null, (Individual)this.subject, this.vreq, false);
    }

    @Test(expected=NullPointerException.class)
    public void subjectIsNull() throws InvalidConfigurationException {
        this.op = this.buildOperation("default");
        this.optm = new NonCollatingOPTM(this.op, null, this.vreq, false);
    }

    @Test(expected=NullPointerException.class)
    public void requestIsNull() throws InvalidConfigurationException {
        this.op = this.buildOperation("default");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, null, false);
    }

    @Test
    public void configFileNotSpecified() throws InvalidConfigurationException {
        this.op = this.buildOperation("default");
        this.opDao.setCustomListViewConfigFileName(this.op, null);
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        Assert.assertEquals((String)"uses default config", (Object)true, (Object)this.optm.hasDefaultListView());
    }

    @Test
    public void configFilePathCantBeTranslated() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("fileHasNoRealPath");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("no real path", "java.io.File.<init>");
    }

    @Test
    public void configFileNotFound() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("configFileDoesNotExist");
        String bogusFilepath = new File(configDir, "doesNotExist").getAbsolutePath();
        String path = "/config/" + this.opDao.getCustomListViewConfigFileName(this.op);
        this.ctx.setRealPath(path, bogusFilepath);
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("file not found", "Can't find config file");
    }

    @Test
    public void templateDoesNotExist() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("templateDoesNotExist");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("template doesn't exist", "Specified template does not exist");
    }

    @Test
    public void collatedNoSubclassSelector() throws InvalidConfigurationException {
        this.thrown.expect(InvalidConfigurationException.class);
        this.thrown.expectMessage("Query does not select a subclass variable");
        this.op = this.buildOperation("selectQueryCollatedNoSelect");
        this.optm = new CheckingCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
    }

    @Test
    public void collatedNoSubclassOrder() throws InvalidConfigurationException {
        this.thrown.expect(InvalidConfigurationException.class);
        this.thrown.expectMessage("Query does not sort first by subclass variable");
        this.op = this.buildOperation("selectQueryCollatedNoOrder");
        this.optm = new CheckingCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
    }

    @Test
    public void collatedValid() throws InvalidConfigurationException {
        this.op = this.buildOperation("selectQueryCollatedValid");
        this.optm = new CheckingCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
    }

    @Test
    public void constructQueryNodeMissing() throws InvalidConfigurationException {
        this.mafs.get((HttpServletRequest)this.vreq).setOntModel(this.emptyOntModel(), "vitro:jenaOntModel");
        this.op = this.buildOperation("constructQueryMissing");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, true);
    }

    @Test
    public void constructQueryMultipleValues() throws InvalidConfigurationException {
        this.mafs.get((HttpServletRequest)this.vreq).setOntModel(this.emptyOntModel(), "vitro:jenaOntModel");
        this.op = this.buildOperation("constructQueryMultiple");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, true);
        this.assertConstructQueries("multiple construct queries", "ONE", "TWO", "THREE");
    }

    @Test
    public void postProcessorNameEmpty() throws InvalidConfigurationException {
        this.op = this.buildOperation("postProcessorNameEmpty");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertPostProcessorClass("pp name empty", DefaultObjectPropertyDataPostProcessor.class);
    }

    @Test
    public void postProcessorClassNotFound() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("postProcessorClassNotFound");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("pp class not found", "java.lang.ClassNotFoundException");
        this.assertPostProcessorClass("pp class not found", DefaultObjectPropertyDataPostProcessor.class);
    }

    @Test
    public void postProcessorClassIsNotSuitable() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("postProcessorClassNotSuitable");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("pp doesn't implement required interface", "java.lang.ClassCastException");
        this.assertPostProcessorClass("pp doesn't implement required interface", DefaultObjectPropertyDataPostProcessor.class);
    }

    @Test
    public void postProcessorClassHasWrongConstructor() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("postProcessorWrongConstructor");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("pp has wrong constructor", "java.lang.NoSuchMethodException");
        this.assertPostProcessorClass("pp has wrong constructor", DefaultObjectPropertyDataPostProcessor.class);
    }

    @Test
    public void postProcessorConstructorThrowsAnException() throws InvalidConfigurationException {
        this.captureLogsFromPropertyListConfig();
        this.op = this.buildOperation("postProcessorConstructorThrowsException");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertLogMessagesContains("pp throws an exception", "java.lang.reflect.InvocationTargetException");
        this.assertPostProcessorClass("pp throws an exception", DefaultObjectPropertyDataPostProcessor.class);
    }

    @Test
    public void postProcessorOK() throws InvalidConfigurationException {
        this.op = this.buildOperation("postProcessorOK");
        this.optm = new NonCollatingOPTM(this.op, (Individual)this.subject, this.vreq, false);
        this.assertPostProcessorClass("pp OK", PostProcessorOK.class);
    }

    private OntModel emptyOntModel() {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    private ObjectProperty buildOperation(String name) {
        ObjectProperty property = new ObjectProperty();
        property.setURI("http://" + name);
        this.opDao.addObjectProperty(property);
        this.opDao.setCustomListViewConfigFileName(property, "testConfig-" + name + ".xml");
        return property;
    }

    private void captureLogsFromPropertyListConfig() {
        this.captureLogOutput(PropertyListConfig.class, this.logMessages, true);
    }

    private void assertLogMessagesContains(String message, String expected) {
        if (this.logMessages.toString().contains(expected)) {
            return;
        }
        Assert.fail((String)(message + "\nLOG\n" + this.logMessages + "\nDOES NOT CONTAIN\n" + expected));
    }

    private void assertConstructQueries(String message, String ... expectedArray) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedArray));
        Set actual = null;
        try {
            Method m = ObjectPropertyTemplateModel.class.getDeclaredMethod("getConstructQueries", new Class[0]);
            m.setAccessible(true);
            actual = (Set)m.invoke((Object)this.optm, new Object[0]);
        }
        catch (Exception e) {
            Assert.fail((String)(message + " - " + e));
        }
        this.assertEqualSets(message, expected, actual);
    }

    private void assertPostProcessorClass(String message, Class<?> expected) {
        try {
            Field configField = ObjectPropertyTemplateModel.class.getDeclaredField("config");
            configField.setAccessible(true);
            PropertyListConfig config = (PropertyListConfig)configField.get(this.optm);
            ObjectPropertyDataPostProcessor pp = config.getPostprocessor();
            if (pp == null) {
                Assert.assertNull((String)(message + " - postprocessor is null"), expected);
            } else {
                Assert.assertEquals((String)message, expected, pp.getClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)(message + " - " + e));
        }
    }

    public static class PostProcessorOK
    implements ObjectPropertyDataPostProcessor {
        public PostProcessorOK(ObjectPropertyTemplateModel optm, WebappDaoFactory wadf) {
        }

        public void process(List<Map<String, String>> data) {
        }
    }

    public static class PostProcessorThrowsException
    implements ObjectPropertyDataPostProcessor {
        public PostProcessorThrowsException(ObjectPropertyTemplateModel optm, WebappDaoFactory wadf) {
            throw new RuntimeException("Constructor throws exception");
        }

        public void process(List<Map<String, String>> data) {
        }
    }

    public static class PostProcessorWrongConstructor
    implements ObjectPropertyDataPostProcessor {
        public void process(List<Map<String, String>> data) {
        }
    }

    public static class ClassNotSuitable {
        public ClassNotSuitable(ObjectPropertyTemplateModel optm, WebappDaoFactory wadf) {
        }
    }

    private class CheckingCollatingOPTM
    extends CollatedObjectPropertyTemplateModel {
        CheckingCollatingOPTM(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing) throws InvalidConfigurationException {
            super(op, subject, vreq, editing, Collections.emptyList());
        }

        protected TemplateLoader getFreemarkerTemplateLoader() {
            return ObjectPropertyTemplateModel_PropertyListConfigTest.this.tl;
        }
    }

    private class NonCollatingOPTM
    extends ObjectPropertyTemplateModel {
        NonCollatingOPTM(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing) throws InvalidConfigurationException {
            super(op, subject, vreq, editing);
        }

        protected boolean isEmpty() {
            return true;
        }

        public boolean isCollatedBySubclass() {
            return false;
        }

        protected TemplateLoader getFreemarkerTemplateLoader() {
            return ObjectPropertyTemplateModel_PropertyListConfigTest.this.tl;
        }
    }
}

