/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.tags;

import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.tags.EditTag;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringEscapeUtils;

public class OptionTag
extends EditTag {
    private String name = null;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void outputOptionsMarkup(List optList, JspWriter out) throws IOException {
        for (Option opt : optList) {
            if (opt.getValue() == null) {
                opt.setValue("");
            }
            if (opt.getBody() == null) {
                opt.setBody("");
            }
            out.print("<option value=\"" + StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)opt.getValue()) + "\"");
            if (opt.getSelected()) {
                out.print(" selected=\"selected\"");
            }
            out.print(">");
            out.print(StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)opt.getBody()));
            out.print("</option>\n");
        }
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            List<Option> optList = null;
            ListOrderedMap optGroups = null;
            try {
                optList = this.getFormObject().getOptionLists().get(this.name);
                this.outputOptionsMarkup(optList, out);
            }
            catch (ClassCastException e) {
                optGroups = (ListOrderedMap)this.getFormObject().getOptionLists().get(this.name);
                OrderedMapIterator ogKey = optGroups.mapIterator();
                while (ogKey.hasNext()) {
                    String optGroupName = (String)ogKey.next();
                    out.println("<optgroup label=\"" + StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)optGroupName) + "\">");
                    this.outputOptionsMarkup((List)optGroups.get((Object)optGroupName), out);
                    out.println("</optgroup>");
                }
            }
            catch (NullPointerException npe) {
                System.out.println("OptionTag could not find option list for " + this.name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JspException(ex.getMessage());
        }
        return 0;
    }
}

