/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.PermissionRegistry;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionSetsSmokeTest
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(PermissionSetsSmokeTest.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            new SmokeTester(this, ctx, ss).test();
        }
        catch (Exception e) {
            ss.fatal(this, "Found a problem while testing the PermissionSets", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static class SmokeTester {
        private ServletContextListener listener;
        private final ServletContext ctx;
        private final StartupStatus ss;
        private final UserAccountsDao uaDao;

        public SmokeTester(ServletContextListener listener, ServletContext ctx, StartupStatus ss) {
            this.listener = listener;
            this.ctx = ctx;
            this.ss = ss;
            this.uaDao = ModelAccess.on(ctx).getWebappDaoFactory().getUserAccountsDao();
        }

        public void test() {
            this.checkForPermissionSetsWithoutLabels();
            this.checkForReferencesToNonexistentPermissionSets();
            this.checkForReferencesToNonexistentPermissions();
            this.warnIfNoPermissionSetsForNewUsers();
        }

        private void checkForPermissionSetsWithoutLabels() {
            for (PermissionSet ps : this.uaDao.getAllPermissionSets()) {
                if (!ps.getLabel().isEmpty()) continue;
                this.ss.warning(this.listener, "This PermissionSet has no label: " + ps.getUri());
            }
        }

        private void checkForReferencesToNonexistentPermissionSets() {
            for (UserAccount user : this.uaDao.getAllUserAccounts()) {
                for (String psUri : user.getPermissionSetUris()) {
                    if (this.uaDao.getPermissionSetByUri(psUri) != null) continue;
                    this.ss.warning(this.listener, "The user '" + user.getFirstName() + " " + user.getLastName() + "' has the PermissionSet '" + psUri + "', but the PermissionSet doesn't exist.");
                }
            }
        }

        private void checkForReferencesToNonexistentPermissions() {
            PermissionRegistry registry = PermissionRegistry.getRegistry(this.ctx);
            for (PermissionSet ps : this.uaDao.getAllPermissionSets()) {
                for (String pUri : ps.getPermissionUris()) {
                    if (registry.isPermission(pUri)) continue;
                    this.ss.warning(this.listener, "The PermissionSet '" + ps.getLabel() + "' has the Permission '" + pUri + "', but the Permission is not found in the registry.");
                }
            }
        }

        private void warnIfNoPermissionSetsForNewUsers() {
            for (PermissionSet ps : this.uaDao.getAllPermissionSets()) {
                if (!ps.isForNewUsers()) continue;
                return;
            }
            this.ss.warning(this.listener, "No PermissionSet has been declared to be a PermissionSet for new users.");
        }
    }
}

