/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.ResourceFactory;

public class Property
extends BaseResourceBean
implements ResourceBean {
    private static Log log = LogFactory.getLog(Property.class);
    private String customEntryForm = null;
    private String groupURI = null;
    private String label = null;
    private final boolean subjectSide = true;
    private String domainVClassURI = null;
    private String rangeVClassURI = null;
    private boolean editLinkSuppressed = false;
    private boolean addLinkSuppressed = false;
    private boolean deleteLinkSuppressed = false;

    public Property() {
        this.groupURI = null;
        this.label = null;
    }

    public Property(String URI2) {
        this.setURI(URI2);
    }

    public String getCustomEntryForm() {
        return this.customEntryForm;
    }

    public void setCustomEntryForm(String s) {
        this.customEntryForm = s;
    }

    public String getGroupURI() {
        return this.groupURI;
    }

    public void setGroupURI(String in) {
        this.groupURI = in;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDomainVClassURI() {
        return this.domainVClassURI;
    }

    public void setDomainVClassURI(String domainVClassURI) {
        this.domainVClassURI = domainVClassURI;
    }

    public String getRangeVClassURI() {
        return this.rangeVClassURI;
    }

    public void setRangeVClassURI(String rangeVClassURI) {
        this.rangeVClassURI = rangeVClassURI;
    }

    public boolean isSubjectSide() {
        return true;
    }

    public boolean isEditLinkSuppressed() {
        return this.editLinkSuppressed;
    }

    public boolean isAddLinkSuppressed() {
        return this.addLinkSuppressed;
    }

    public boolean isDeleteLinkSuppressed() {
        return this.deleteLinkSuppressed;
    }

    public void setEditLinkSuppressed(boolean editLinkSuppressed) {
        this.editLinkSuppressed = editLinkSuppressed;
    }

    public void setAddLinkSuppressed(boolean addLinkSuppressed) {
        if (this.addLinkSuppressed) {
            throw new RuntimeException("addLinkSuppressed already true");
        }
        this.addLinkSuppressed = addLinkSuppressed;
    }

    public void setDeleteLinkSuppressed(boolean deleteLinkSuppressed) {
        this.deleteLinkSuppressed = deleteLinkSuppressed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.localNameFor(this.getURI()) + ", domain=" + this.localNameFor(this.getDomainVClassURI()) + ", range=" + this.localNameFor(this.getRangeVClassURI()) + "]";
    }

    private String localNameFor(String uri) {
        try {
            return ResourceFactory.createResource((String)uri).getLocalName();
        }
        catch (Exception e) {
            return uri;
        }
    }

    public static class DisplayComparatorIgnoringPropertyGroup
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Property p2;
            Property p1 = o1 == null ? null : (Property)o1;
            Property property = p2 = o2 == null ? null : (Property)o2;
            if (p1 == null || p2 == null) {
                return 0;
            }
            int diff = this.determineDisplayRank(p1) - this.determineDisplayRank(p2);
            if (diff == 0) {
                String p1Str = p1.getLabel() == null ? p1.getURI() : p1.getLabel();
                String p2Str = p2.getLabel() == null ? p2.getURI() : p2.getLabel();
                return p1Str.compareTo(p2Str);
            }
            return diff;
        }

        private int determineDisplayRank(Property p) {
            if (p instanceof DataProperty) {
                DataProperty dp = (DataProperty)p;
                return dp.getDisplayTier();
            }
            if (p instanceof ObjectProperty) {
                ObjectProperty op = (ObjectProperty)p;
                return op.getDomainDisplayTier();
            }
            log.error((Object)"Property is of unknown class in PropertyRanker()");
            return 0;
        }
    }
}

