/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsCreatePasswordPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsFirstTimeExternalPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsMyAccountPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsResetPasswordPage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginRedirector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="AccountsUser", urlPatterns={"/accounts/*"})
public class UserAccountsUserController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(UserAccountsUserController.class);
    private static final String ACTION_CREATE_PASSWORD = "/createPassword";
    private static final String ACTION_RESET_PASSWORD = "/resetPassword";
    private static final String ACTION_MY_ACCOUNT = "/myAccount";
    private static final String ACTION_FIRST_TIME_EXTERNAL = "/firstTimeExternal";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        String action = vreq.getPathInfo();
        if (ACTION_MY_ACCOUNT.equals(action)) {
            return SimplePermission.EDIT_OWN_ACCOUNT.ACTION;
        }
        return AuthorizationRequest.AUTHORIZED;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if (log.isDebugEnabled()) {
            this.dumpRequestParameters((HttpServletRequest)vreq);
        }
        String action = vreq.getPathInfo();
        log.debug((Object)("action = '" + action + "'"));
        if (ACTION_MY_ACCOUNT.equals(action)) {
            return this.handleMyAccountRequest(vreq);
        }
        if (ACTION_CREATE_PASSWORD.equals(action)) {
            return this.handleCreatePasswordRequest(vreq);
        }
        if (ACTION_RESET_PASSWORD.equals(action)) {
            return this.handleResetPasswordRequest(vreq);
        }
        if (ACTION_FIRST_TIME_EXTERNAL.equals(action)) {
            return this.handleFirstTimeLoginFromExternalAccount(vreq);
        }
        return this.handleInvalidRequest(vreq);
    }

    private ResponseValues handleMyAccountRequest(VitroRequest vreq) {
        UserAccountsMyAccountPage page = new UserAccountsMyAccountPage(vreq);
        if (page.isSubmit() && page.isValid()) {
            page.updateAccount();
        }
        return page.showPage();
    }

    private ResponseValues handleCreatePasswordRequest(VitroRequest vreq) {
        UserAccountsCreatePasswordPage page = new UserAccountsCreatePasswordPage(vreq);
        if (page.isBogus()) {
            return this.showHomePage(vreq, page.getBogusMessage());
        }
        if (page.isSubmit() && page.isValid()) {
            page.createPassword();
            return this.showHomePage(vreq, page.getSuccessMessage());
        }
        return page.showPage();
    }

    private ResponseValues handleResetPasswordRequest(VitroRequest vreq) {
        UserAccountsResetPasswordPage page = new UserAccountsResetPasswordPage(vreq);
        if (page.isBogus()) {
            return this.showHomePage(vreq, page.getBogusMessage());
        }
        if (page.isSubmit() && page.isValid()) {
            page.resetPassword();
            return this.showHomePage(vreq, page.getSuccessMessage());
        }
        return page.showPage();
    }

    private ResponseValues handleFirstTimeLoginFromExternalAccount(VitroRequest vreq) {
        UserAccountsFirstTimeExternalPage page = new UserAccountsFirstTimeExternalPage(vreq);
        if (page.isBogus()) {
            return this.showHomePage(vreq, page.getBogusMessage());
        }
        if (page.isSubmit() && page.isValid()) {
            try {
                UserAccount userAccount = page.createAccount();
                Authenticator auth = Authenticator.getInstance((HttpServletRequest)vreq);
                auth.recordLoginAgainstUserAccount(userAccount, LoginStatusBean.AuthenticationSource.EXTERNAL);
                return this.showLoginRedirection(vreq, page.getAfterLoginUrl());
            }
            catch (Authenticator.LoginNotPermitted e) {
                return this.showHomePage(vreq, UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)vreq));
            }
        }
        return page.showPage();
    }

    private ResponseValues handleInvalidRequest(VitroRequest vreq) {
        return this.showHomePage(vreq, UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)vreq));
    }

    private ResponseValues showHomePage(VitroRequest vreq, String message) {
        DisplayMessage.setMessage((HttpServletRequest)vreq, message);
        return new RedirectResponseValues("/");
    }

    private ResponseValues showLoginRedirection(VitroRequest vreq, String afterLoginUrl) {
        LoginRedirector lr = new LoginRedirector((HttpServletRequest)vreq, afterLoginUrl);
        DisplayMessage.setMessage((HttpServletRequest)vreq, lr.assembleWelcomeMessage());
        String uri = lr.getRedirectionUriForLoggedInUser();
        return new RedirectResponseValues(this.stripContextPath(vreq, uri));
    }

    private String stripContextPath(VitroRequest vreq, String uri) {
        if (uri == null || uri.isEmpty() || uri.equals(vreq.getContextPath())) {
            return "/";
        }
        if (uri.contains("://")) {
            return uri;
        }
        if (uri.startsWith(vreq.getContextPath() + '/')) {
            return uri.substring(vreq.getContextPath().length());
        }
        return uri;
    }

    public static String getBogusStandardMessage(HttpServletRequest req) {
        return I18n.bundle(req).text("request_failed", new Object[0]);
    }
}

