/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LogoutRedirector;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="logout", urlPatterns={"/logout"})
public class Logout
extends HttpServlet {
    private static final Log log = LogFactory.getLog((String)Logout.class.getName());
    private static final String HEADING_REFERRER = "referer";

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String referrer = this.getReferringPage(request);
            String redirectUrl = LogoutRedirector.getRedirectUrl(request, response, referrer);
            Authenticator.getInstance(request).recordUserIsLoggedOut();
            DisplayMessage.setMessage(request, I18n.bundle(request).text("logged_out", new Object[0]));
            response.sendRedirect(redirectUrl);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    private String getReferringPage(HttpServletRequest request) {
        String referrer = request.getHeader(HEADING_REFERRER);
        if (referrer == null) {
            referrer = "/.";
        }
        log.debug((Object)("Referring page is '" + referrer + "'"));
        return referrer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }
}

