/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SelectedLocale {
    private static final Log log = LogFactory.getLog(SelectedLocale.class);
    protected static final String ATTRIBUTE_NAME = "SELECTED_LOCALE";

    public static void setForcedLocale(ServletContext ctx, Locale forcedLocale) {
        log.debug((Object)("Set forced locale: " + forcedLocale));
        ctx.setAttribute(ATTRIBUTE_NAME, (Object)new ContextSelectedLocale(forcedLocale));
    }

    public static void setSelectedLocale(HttpServletRequest req, Locale selectedLocale) {
        log.debug((Object)("Set selected locale: " + selectedLocale));
        req.getSession().setAttribute(ATTRIBUTE_NAME, (Object)new SessionSelectedLocale(selectedLocale));
    }

    public static Locale getOverridingLocale(HttpServletRequest req) {
        List<Locale> selectableLocales;
        Locale selectedLocale;
        HttpSession session = req.getSession();
        ServletContext ctx = session.getServletContext();
        Object ctxInfo = ctx.getAttribute(ATTRIBUTE_NAME);
        Optional<Locale> forcedLocale = SelectedLocale.getForcedLocale(ctxInfo);
        if (forcedLocale.isPresent()) {
            return forcedLocale.get();
        }
        Object sessionInfo = session.getAttribute(ATTRIBUTE_NAME);
        if (sessionInfo instanceof SessionSelectedLocale && (selectedLocale = ((SessionSelectedLocale)sessionInfo).getSelectedLocale()) != null) {
            log.debug((Object)("Found selected locale in the session: " + selectedLocale));
            return selectedLocale;
        }
        if (ctxInfo instanceof ContextSelectedLocale && (selectableLocales = ((ContextSelectedLocale)ctxInfo).getSelectableLocales()) != null && !selectableLocales.isEmpty()) {
            Locale defaultLocale = selectableLocales.get(0);
            log.debug((Object)("Using first selectable locale as default: " + defaultLocale));
            return defaultLocale;
        }
        Locale fallbackLocale = SelectedLocale.getFallbackLocale();
        log.debug((Object)("Using fallback locale as default: " + fallbackLocale));
        return fallbackLocale;
    }

    public static Locale getOverridingLocale(ServletContext ctx, List<Locale> preferredLocales) {
        List<Locale> selectableLocales;
        Object ctxInfo = ctx.getAttribute(ATTRIBUTE_NAME);
        Optional<Locale> forcedLocale = SelectedLocale.getForcedLocale(ctxInfo);
        if (forcedLocale.isPresent()) {
            return forcedLocale.get();
        }
        if (ctxInfo instanceof ContextSelectedLocale && Objects.nonNull(selectableLocales = ((ContextSelectedLocale)ctxInfo).getSelectableLocales()) && Objects.nonNull(preferredLocales)) {
            for (Locale preferredLocal : preferredLocales) {
                for (Locale selectableLocale : selectableLocales) {
                    if (!selectableLocale.equals(preferredLocal)) continue;
                    log.debug((Object)("Using first matching selectable locale from context: " + selectableLocale));
                    return selectableLocale;
                }
            }
        }
        if (Objects.nonNull(preferredLocales) && !preferredLocales.isEmpty()) {
            Locale preferredLocal = preferredLocales.get(0);
            log.debug((Object)("Using first preferred locale as default: " + preferredLocal));
            return preferredLocal;
        }
        Locale fallbackLocale = SelectedLocale.getFallbackLocale();
        log.debug((Object)("Using fallback locale as default: " + fallbackLocale));
        return fallbackLocale;
    }

    public static Locale getFallbackLocale() {
        return new Locale("en", "US");
    }

    public static Locale getCurrentLocale(HttpServletRequest req) {
        Locale overridingLocale = SelectedLocale.getOverridingLocale(req);
        if (overridingLocale != null) {
            return overridingLocale;
        }
        Locale requestLocale = req.getLocale();
        if (requestLocale != null) {
            log.debug((Object)("Found locale in the request: " + requestLocale));
            return requestLocale;
        }
        log.debug((Object)("Using default locale: " + Locale.getDefault()));
        return Locale.getDefault();
    }

    public static Locale getPreferredLocale(ServletContext ctx, List<Locale> preferredLocales) {
        Locale overridingLocale = SelectedLocale.getOverridingLocale(ctx, preferredLocales);
        if (overridingLocale != null) {
            return overridingLocale;
        }
        log.debug((Object)("Using default locale: " + Locale.getDefault()));
        return Locale.getDefault();
    }

    private static Optional<Locale> getForcedLocale(Object ctxInfo) {
        Locale forcedLocale;
        if (ctxInfo instanceof ContextSelectedLocale && (forcedLocale = ((ContextSelectedLocale)ctxInfo).getForcedLocale()) != null) {
            log.debug((Object)("Found forced locale in the context: " + forcedLocale));
            return Optional.of(forcedLocale);
        }
        return Optional.empty();
    }

    public static void setSelectableLocales(ServletContext ctx, List<Locale> selectableLocales) {
        log.debug((Object)("Setting selectable locales: " + selectableLocales));
        ctx.setAttribute(ATTRIBUTE_NAME, (Object)new ContextSelectedLocale(selectableLocales));
    }

    public static List<Locale> getSelectableLocales(HttpServletRequest req) {
        return SelectedLocale.getSelectableLocales(req.getSession().getServletContext());
    }

    public static List<Locale> getSelectableLocales(ServletContext ctx) {
        List<Locale> selectableLocales;
        Object ctxInfo = ctx.getAttribute(ATTRIBUTE_NAME);
        if (ctxInfo instanceof ContextSelectedLocale && (selectableLocales = ((ContextSelectedLocale)ctxInfo).getSelectableLocales()) != null) {
            log.debug((Object)("Returning selectable locales: " + selectableLocales));
            return selectableLocales;
        }
        log.debug((Object)"No selectable locales were found. Returning an empty list.");
        return Collections.emptyList();
    }

    protected static class SessionSelectedLocale {
        private final Locale selectedLocale;

        public SessionSelectedLocale(Locale selectedLocale) {
            this.selectedLocale = selectedLocale;
        }

        public Locale getSelectedLocale() {
            return this.selectedLocale;
        }

        public String toString() {
            return "SessionSelectedLocale[" + this.selectedLocale + "]";
        }
    }

    protected static class ContextSelectedLocale {
        private final Locale forcedLocale;
        private final List<Locale> selectableLocales;

        public ContextSelectedLocale(Locale forcedLocale) {
            if (forcedLocale == null) {
                throw new NullPointerException("forcedLocale may not be null.");
            }
            this.forcedLocale = forcedLocale;
            this.selectableLocales = Collections.emptyList();
        }

        public ContextSelectedLocale(List<Locale> selectableLocales) {
            if (selectableLocales == null) {
                selectableLocales = Collections.emptyList();
            }
            this.forcedLocale = null;
            this.selectableLocales = Collections.unmodifiableList(new ArrayList<Locale>(selectableLocales));
        }

        public Locale getForcedLocale() {
            return this.forcedLocale;
        }

        public List<Locale> getSelectableLocales() {
            return this.selectableLocales;
        }

        public String toString() {
            return "ContextSelectedLocale[forced=" + this.forcedLocale + ", selectable=" + this.selectableLocales + "]";
        }
    }
}

