/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import edu.cornell.mannlib.vitro.webapp.ontology.update.AtomicOntologyChange;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyChangeParser {
    private final Log log = LogFactory.getLog(OntologyChangeParser.class);
    private ChangeLogger logger;

    public OntologyChangeParser(ChangeLogger logger) {
        this.logger = logger;
    }

    public ArrayList<AtomicOntologyChange> parseFile(String diffPath) throws IOException {
        ArrayList<AtomicOntologyChange> changeObjects = new ArrayList<AtomicOntologyChange>();
        boolean countColumns = false;
        Object URI2 = null;
        Object rename = null;
        Object sourceURI = null;
        Object destinationURI = null;
        Object stArr = null;
        FileInputStream in = new FileInputStream(new File(diffPath));
        CSVParser readFile = new CSVParser((Reader)new InputStreamReader(in), CSVFormat.DEFAULT.withRecordSeparator('\t'));
        int rowNum = 0;
        for (CSVRecord record : readFile) {
            ++rowNum;
            if (record.size() != 5) {
                this.logger.logError("Invalid PromptDiff data at row " + rowNum + ". Expected 5 columns; found " + record.size());
                continue;
            }
            String col = null;
            AtomicOntologyChange changeObj = new AtomicOntologyChange();
            col = record.get(0);
            if (col != null && col.length() > 0) {
                changeObj.setSourceURI(col);
            }
            if ((col = record.get(1)) != null && col.length() > 0) {
                changeObj.setDestinationURI(col);
            }
            if ((col = record.get(4)) != null && col.length() > 0) {
                changeObj.setNotes(col);
            }
            if ("Yes".equals(record.get(2))) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.RENAME);
            } else if ("Delete".equals(record.get(3))) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.DELETE);
            } else if ("Add".equals(record.get(3))) {
                changeObj.setAtomicChangeType(AtomicOntologyChange.AtomicChangeType.ADD);
            } else {
                this.logger.logError("Invalid rename or change type data: '" + record.get(2) + " " + record.get(3) + "'");
            }
            this.log.debug((Object)changeObj);
            changeObjects.add(changeObj);
        }
        readFile.close();
        if (changeObjects.size() == 0) {
            this.logger.log("No ABox updates are required.");
        }
        return changeObjects;
    }
}

