/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.reasoner.IndividualURIQueue;
import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ABoxRecomputer {
    private static final Log log = LogFactory.getLog(ABoxRecomputer.class);
    private final SearchIndexer searchIndexer;
    private OntModel tboxModel;
    private OntModel aboxModel;
    private RDFService rdfService;
    private SimpleReasoner simpleReasoner;
    private Object lock1 = new Object();
    private volatile boolean recomputing = false;
    private boolean stopRequested = false;
    private final int BATCH_SIZE = 500;
    private final int REPORTING_INTERVAL = 1000;
    private static final boolean RUN_PLUGINS = true;
    private static final boolean SKIP_PLUGINS = false;

    public ABoxRecomputer(OntModel tboxModel, OntModel aboxModel, RDFService rdfService, SimpleReasoner simpleReasoner, SearchIndexer searchIndexer) {
        this.tboxModel = tboxModel;
        this.aboxModel = aboxModel;
        this.rdfService = rdfService;
        this.simpleReasoner = simpleReasoner;
        this.searchIndexer = searchIndexer;
        this.recomputing = false;
        this.stopRequested = false;
    }

    public boolean isRecomputing() {
        return this.recomputing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompute() {
        Object object = this.lock1;
        synchronized (object) {
            if (this.recomputing) {
                return;
            }
            this.recomputing = true;
        }
        try {
            if (this.searchIndexer != null) {
                this.searchIndexer.pause();
                this.searchIndexer.rebuildIndex();
            }
            log.info((Object)"Recomputing ABox inferences.");
            log.info((Object)"Finding individuals in ABox.");
            Queue<String> individualURIs = this.getAllIndividualURIs();
            log.info((Object)("Recomputing inferences for " + individualURIs.size() + " individuals"));
            this.recomputeIndividuals(individualURIs, new TypeCaches());
            log.info((Object)"Finished recomputing inferences");
        }
        finally {
            if (this.searchIndexer != null) {
                this.searchIndexer.unpause();
            }
            object = this.lock1;
            synchronized (object) {
                this.recomputing = false;
            }
        }
    }

    public void recompute(Queue<String> individualURIs) {
        boolean sizableRecompute = individualURIs.size() > 20;
        try {
            if (sizableRecompute && this.searchIndexer != null) {
                this.searchIndexer.pause();
            }
            this.recomputeIndividuals(individualURIs);
        }
        finally {
            if (sizableRecompute && this.searchIndexer != null) {
                this.searchIndexer.unpause();
            }
        }
    }

    private void recomputeIndividuals(Queue<String> individuals) {
        this.recomputeIndividuals(individuals, new TypeCaches());
    }

    protected void recomputeIndividuals(Queue<String> individuals, TypeCaches caches) {
        if (individuals == null) {
            return;
        }
        long start = System.currentTimeMillis();
        int size = individuals.size();
        int numInds = 0;
        Model rebuildModel = ModelFactory.createDefaultModel();
        Model additionalInferences = ModelFactory.createDefaultModel();
        ArrayList<String> individualsInBatch = new ArrayList<String>();
        while (!individuals.isEmpty()) {
            String individualURI = individuals.poll();
            try {
                boolean reportingInterval;
                additionalInferences.add(this.recomputeIndividual(individualURI, rebuildModel, caches, individuals));
                individualsInBatch.add(individualURI);
                boolean batchFilled = ++numInds % 500 == 0;
                boolean bl = reportingInterval = numInds % 1000 == 0;
                if (batchFilled || individuals.isEmpty()) {
                    log.debug((Object)(rebuildModel.size() + " total inferences"));
                    this.updateInferenceModel(rebuildModel, individualsInBatch);
                    rebuildModel.removeAll();
                    individualsInBatch.clear();
                }
                if (reportingInterval) {
                    log.info((Object)("Still recomputing inferences (" + numInds + "/" + size + " individuals)"));
                    log.info((Object)((System.currentTimeMillis() - start) / (long)numInds + " ms per individual"));
                }
                if (!this.stopRequested) continue;
                log.info((Object)"a stopRequested signal was received during recomputeIndividuals. Halting Processing.");
                return;
            }
            catch (Exception e) {
                log.error((Object)("Error recomputing inferences for individual <" + individualURI + ">"), (Throwable)e);
            }
        }
        if (additionalInferences.size() > 0L) {
            log.debug((Object)"Writing additional inferences generated by reasoner plugins.");
            ChangeSet change = this.rdfService.manufactureChangeSet();
            change.addAddition(this.makeN3InputStream(additionalInferences), RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
            try {
                this.rdfService.changeSetUpdate(change);
            }
            catch (RDFServiceException e) {
                log.error((Object)"Unable to write additional inferences from reasoner plugins", (Throwable)e);
            }
        }
    }

    private Model recomputeIndividual(String individualURI, Model rebuildModel, TypeCaches caches, Collection<String> individualQueue) throws RDFServiceException {
        long prevRebuildSize;
        long start = System.currentTimeMillis();
        Model assertions = this.getAssertions(individualURI);
        log.debug((Object)(System.currentTimeMillis() - start + " ms to get assertions."));
        long l = prevRebuildSize = this.simpleReasoner.getSameAsEnabled() ? rebuildModel.size() : 0L;
        if (this.simpleReasoner.getSameAsEnabled()) {
            Set<String> sameAsInds = this.getSameAsIndividuals(individualURI);
            for (String sameAsInd : sameAsInds) {
                Resource sameAsIndRes;
                Model sameAsIndAssertions = this.getAssertions(sameAsInd);
                rebuildModel.add(this.rewriteInferences(this.getAssertions(sameAsInd), individualURI));
                Resource indRes = ResourceFactory.createResource((String)individualURI);
                if (assertions.contains(indRes, OWL.sameAs, (RDFNode)(sameAsIndRes = ResourceFactory.createResource((String)sameAsInd))) || rebuildModel.contains(indRes, OWL.sameAs, (RDFNode)sameAsIndRes)) continue;
                individualQueue.add(sameAsInd);
                rebuildModel.add(indRes, OWL.sameAs, (RDFNode)sameAsIndRes);
            }
            if (rebuildModel.size() - prevRebuildSize > 0L) {
                individualQueue.addAll(sameAsInds);
            }
        }
        Model additionalInferences = this.recomputeIndividual(individualURI, null, assertions, rebuildModel, caches, true);
        return additionalInferences;
    }

    private Model recomputeIndividual(String individualURI, String aliasURI, Model assertions, Model rebuildModel, TypeCaches caches, boolean runPlugins) throws RDFServiceException {
        Model additionalInferences = ModelFactory.createDefaultModel();
        Resource individual = ResourceFactory.createResource((String)individualURI);
        long start = System.currentTimeMillis();
        Model types = ModelFactory.createDefaultModel();
        types.add(assertions.listStatements(individual, RDF.type, (RDFNode)null));
        types.add(rebuildModel.listStatements(individual, RDF.type, (RDFNode)null));
        Model inferredTypes = this.rewriteInferences(this.getInferredTypes(individual, types, caches), aliasURI);
        rebuildModel.add(inferredTypes);
        log.trace((Object)(System.currentTimeMillis() - start + " to infer " + inferredTypes.size() + " types"));
        start = System.currentTimeMillis();
        types.add(inferredTypes);
        Model mst = this.getMostSpecificTypes(individual, types, caches);
        rebuildModel.add(this.rewriteInferences(mst, aliasURI));
        log.trace((Object)(System.currentTimeMillis() - start + " to infer " + mst.size() + " mostSpecificTypes"));
        start = System.currentTimeMillis();
        Model inferredInvs = this.getInferredInverseStatements(individualURI);
        inferredInvs.remove(assertions);
        rebuildModel.add(this.rewriteInferences(inferredInvs, aliasURI));
        log.trace((Object)(System.currentTimeMillis() - start + " to infer " + inferredInvs.size() + " inverses"));
        List<ReasonerPlugin> pluginList = this.simpleReasoner.getPluginList();
        if (runPlugins && pluginList.size() > 0) {
            Model tmpModel = ModelFactory.createDefaultModel();
            StmtIterator sit = assertions.listStatements();
            while (sit.hasNext()) {
                Statement s = sit.nextStatement();
                for (ReasonerPlugin plugin : pluginList) {
                    plugin.addedABoxStatement(s, (Model)this.aboxModel, tmpModel, this.tboxModel);
                }
            }
            StmtIterator tmpIt = tmpModel.listStatements();
            while (tmpIt.hasNext()) {
                Statement tmpStmt = tmpIt.nextStatement();
                if (individual.equals((Object)tmpStmt.getSubject())) {
                    rebuildModel.add(tmpStmt);
                    continue;
                }
                additionalInferences.add(tmpStmt);
            }
        }
        return additionalInferences;
    }

    private Model getAssertions(String individualURI) throws RDFServiceException {
        String queryStr = "CONSTRUCT { \n    <" + individualURI + "> ?p ?value \n} WHERE { \n    GRAPH ?g { \n        <" + individualURI + "> ?p ?value \n    } \n    FILTER (?g != <" + "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf" + ">)\n} \n";
        Model model = ModelFactory.createDefaultModel();
        this.rdfService.sparqlConstructQuery(queryStr, model);
        return model;
    }

    private Model getInferredTypes(Resource individual, Model assertedTypes, TypeCaches caches) {
        if (caches == null) {
            return this.getInferredTypes(individual, assertedTypes);
        }
        TypeList key = new TypeList(assertedTypes, RDF.type);
        Model inferredTypes = caches.getInferredTypesToModel(key, individual);
        if (inferredTypes == null) {
            inferredTypes = this.getInferredTypes(individual, assertedTypes);
            caches.cacheInferredTypes(key, inferredTypes);
        }
        return inferredTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getInferredTypes(Resource individual, Model assertedTypes) {
        new TypeList(assertedTypes, RDF.type);
        String queryStr = "CONSTRUCT { \n    <" + individual.getURI() + "> a ?type \n} WHERE { \n    <" + individual.getURI() + "> a ?assertedType .\n    { ?assertedType <" + RDFS.subClassOf.getURI() + "> ?type } \n     UNION \n    { ?assertedType <" + OWL.equivalentClass.getURI() + "> ?type } \n    FILTER (isURI(?type)) \n    FILTER NOT EXISTS { \n        <" + individual.getURI() + "> a ?type \n    } \n} \n";
        Model union = ModelFactory.createUnion((Model)assertedTypes, (Model)this.tboxModel);
        this.tboxModel.enterCriticalSection(true);
        try {
            Query q = QueryFactory.create((String)queryStr);
            QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)union);
            Model model = qe.execConstruct();
            return model;
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
    }

    private Model getMostSpecificTypes(Resource individual, Model assertedTypes, TypeCaches caches) {
        if (caches == null) {
            return this.getMostSpecificTypes(individual, assertedTypes);
        }
        TypeList key = new TypeList(assertedTypes, RDF.type);
        Model mostSpecificTypes = caches.getMostSpecificTypesToModel(key, individual);
        if (mostSpecificTypes == null) {
            mostSpecificTypes = this.getMostSpecificTypes(individual, assertedTypes);
            caches.cacheMostSpecificTypes(key, mostSpecificTypes);
        }
        return mostSpecificTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getMostSpecificTypes(Resource individual, Model assertedTypes) {
        String queryStr = "CONSTRUCT { \n    <" + individual.getURI() + "> <" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType" + "> ?type \n} WHERE { \n    <" + individual.getURI() + "> a ?type .\n    FILTER (isURI(?type)) \n    FILTER NOT EXISTS { \n        <" + individual.getURI() + "> a ?type2 . \n        ?type2 <" + RDFS.subClassOf.getURI() + "> ?type. \n        FILTER (?type != ?type2) \n        FILTER NOT EXISTS { ?type <" + OWL.equivalentClass + "> ?type2 } \n    } \n    FILTER NOT EXISTS { \n        <" + individual.getURI() + "> <" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType" + "> ?type \n    } \n} \n";
        Model union = ModelFactory.createUnion((Model)assertedTypes, (Model)this.tboxModel);
        this.tboxModel.enterCriticalSection(true);
        try {
            Query q = QueryFactory.create((String)queryStr);
            QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)union);
            Model model = qe.execConstruct();
            return model;
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
    }

    private Model getInferredInverseStatements(String individualURI) throws RDFServiceException {
        String queryStr = "CONSTRUCT { \n    <" + individualURI + "> ?inv ?value \n} WHERE { \n    GRAPH ?gr { \n        ?value ?prop <" + individualURI + "> \n    } \n   FILTER (isURI(?value)) \n   FILTER (?gr != <" + "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf" + ">) \n    { ?prop <" + OWL.inverseOf.getURI() + "> ?inv } \n     UNION \n    { ?inv <" + OWL.inverseOf.getURI() + "> ?prop } \n} \n";
        Model model = ModelFactory.createDefaultModel();
        this.rdfService.sparqlConstructQuery(queryStr, model);
        return model;
    }

    private Model rewriteInferences(Model inferences, String aliasURI) {
        if (aliasURI == null) {
            return inferences;
        }
        Model rewrite = ModelFactory.createDefaultModel();
        Resource alias = ResourceFactory.createResource((String)aliasURI);
        StmtIterator sit = inferences.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            rewrite.add(alias, stmt.getPredicate(), stmt.getObject());
        }
        return rewrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Queue<String> getAllIndividualURIs() {
        IndividualURIQueue<String> individualURIs = new IndividualURIQueue<String>();
        ArrayList<String> classList = new ArrayList<String>();
        this.tboxModel.enterCriticalSection(true);
        try {
            StmtIterator classIt = this.tboxModel.listStatements((Resource)null, RDF.type, (RDFNode)OWL.Class);
            while (classIt.hasNext()) {
                Statement stmt = classIt.nextStatement();
                if (!stmt.getSubject().isURIResource() || stmt.getSubject().getURI() == null || stmt.getSubject().getURI().isEmpty()) continue;
                classList.add(stmt.getSubject().getURI());
            }
        }
        finally {
            this.tboxModel.leaveCriticalSection();
        }
        for (String classURI : classList) {
            String queryString = "SELECT ?s WHERE { ?s a <" + classURI + "> } ";
            this.getIndividualURIs(queryString, individualURIs);
        }
        return individualURIs;
    }

    protected void getIndividualURIs(String queryString, final Queue<String> individuals) {
        int batchSize = 50000;
        int offset = 0;
        final AtomicBoolean done = new AtomicBoolean(false);
        while (!done.get()) {
            String queryStr = queryString + " LIMIT " + 50000 + " OFFSET " + offset;
            if (log.isDebugEnabled()) {
                log.debug((Object)queryStr);
            }
            try {
                this.rdfService.sparqlSelectQuery(queryStr, new ResultSetConsumer(){
                    private int count = 0;

                    @Override
                    protected void processQuerySolution(QuerySolution qs) {
                        ++this.count;
                        Resource resource = qs.getResource("s");
                        if (resource != null && !resource.isAnon()) {
                            individuals.add(resource.getURI());
                        }
                    }

                    @Override
                    protected void endProcessing() {
                        super.endProcessing();
                        if (this.count < 50000) {
                            done.set(true);
                        }
                    }
                });
            }
            catch (RDFServiceException e) {
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(individuals.size() + " in set"));
            }
            offset += 50000;
        }
    }

    protected void addInferenceStatementsFor(String individualUri, Model addTo) throws RDFServiceException {
        StringBuilder builder = new StringBuilder();
        builder.append("CONSTRUCT\n").append("{\n").append("   <").append(individualUri).append("> ?p ?o .\n").append("}\n").append("WHERE\n").append("{\n").append("   GRAPH <").append("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf").append(">\n").append("   {\n").append("       <").append(individualUri).append("> ?p ?o .\n").append("   }\n").append("}\n");
        this.rdfService.sparqlConstructQuery(builder.toString(), addTo);
    }

    protected void updateInferenceModel(Model rebuildModel, Collection<String> individuals) throws RDFServiceException {
        Model existing = ModelFactory.createDefaultModel();
        for (String individualURI : individuals) {
            this.addInferenceStatementsFor(individualURI, existing);
        }
        Model retractions = existing.difference(rebuildModel);
        Model additions = rebuildModel.difference(existing);
        if (additions.size() > 0L || retractions.size() > 0L) {
            long start = System.currentTimeMillis();
            ChangeSet change = this.rdfService.manufactureChangeSet();
            if (retractions.size() > 0L) {
                change.addRemoval(this.makeN3InputStream(retractions), RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
            }
            if (additions.size() > 0L) {
                change.addAddition(this.makeN3InputStream(additions), RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
            }
            this.rdfService.changeSetUpdate(change);
            log.debug((Object)(System.currentTimeMillis() - start + " ms to retract " + retractions.size() + " statements and add " + additions.size() + " statements"));
        }
    }

    private InputStream makeN3InputStream(Model m) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out, "N3");
        return new ByteArrayInputStream(out.toByteArray());
    }

    public Set<String> getSameAsIndividuals(String individualURI) {
        HashSet<String> sameAsInds = new HashSet<String>();
        sameAsInds.add(individualURI);
        this.getSameAsIndividuals(individualURI, sameAsInds);
        sameAsInds.remove(individualURI);
        return sameAsInds;
    }

    private void getSameAsIndividuals(String individualUri, final Set<String> sameAsInds) {
        try {
            final ArrayList addedURIs = new ArrayList();
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT\n").append("   ?object\n").append("WHERE {\n").append("    GRAPH ?g { \n").append("        {\n").append("            <").append(individualUri).append("> <").append(OWL.sameAs).append("> ?object .\n").append("        } UNION {\n").append("            ?object <").append(OWL.sameAs).append("> <").append(individualUri).append("> .\n").append("        }\n").append("    } \n").append("    FILTER (?g != <http://vitro.mannlib.cornell.edu/default/vitro-kb-inf>)\n").append("}\n");
            this.rdfService.sparqlSelectQuery(builder.toString(), new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    Resource object = qs.getResource("object");
                    if (object != null && !sameAsInds.contains(object.getURI())) {
                        sameAsInds.add(object.getURI());
                        addedURIs.add(object.getURI());
                    }
                }
            });
            for (String indUri : addedURIs) {
                this.getSameAsIndividuals(indUri, sameAsInds);
            }
        }
        catch (RDFServiceException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void setStopRequested() {
        this.stopRequested = true;
    }

    private static class TypeList {
        private List<String> typeUris = new ArrayList<String>();
        private Integer hashCode = null;

        TypeList(Model model, Property property) {
            NodeIterator iterator = model.listObjectsOfProperty(property);
            while (iterator.hasNext()) {
                RDFNode node = iterator.next();
                String uri = node.asResource().getURI();
                if (this.typeUris.contains(uri)) continue;
                this.typeUris.add(uri);
            }
        }

        Model constructModel(Resource individual, Property property) {
            Model model = ModelFactory.createDefaultModel();
            for (String uri : this.typeUris) {
                model.add(individual, property, (RDFNode)model.createResource(uri));
            }
            return model;
        }

        Model constructModel(Resource individual, String property) {
            Model model = ModelFactory.createDefaultModel();
            for (String uri : this.typeUris) {
                model.add(individual, model.createProperty(property), (RDFNode)model.createResource(uri));
            }
            return model;
        }

        public void addUri(String uri) {
            if (!this.typeUris.contains(uri)) {
                this.typeUris.add(uri);
                this.hashCode = null;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeList)) {
                return false;
            }
            TypeList otherKey = (TypeList)obj;
            if (this.typeUris.size() != otherKey.typeUris.size()) {
                return false;
            }
            return this.typeUris.containsAll(otherKey.typeUris);
        }

        public int hashCode() {
            if (this.hashCode == null) {
                Collections.sort(this.typeUris);
                StringBuilder builder = new StringBuilder();
                for (String key : this.typeUris) {
                    builder.append('<').append(key).append('>');
                }
                this.hashCode = builder.toString().hashCode();
            }
            return this.hashCode;
        }
    }

    private static class TypeCaches {
        private Map<TypeList, TypeList> inferredTypes = new HashMap<TypeList, TypeList>();
        private Map<TypeList, TypeList> mostSpecificTypes = new HashMap<TypeList, TypeList>();

        private TypeCaches() {
        }

        void cacheInferredTypes(TypeList key, Model model) {
            this.inferredTypes.put(key, new TypeList(model, RDF.type));
        }

        Model getInferredTypesToModel(TypeList key, Resource individual) {
            TypeList types = this.inferredTypes.get(key);
            if (types != null) {
                return types.constructModel(individual, RDF.type);
            }
            return null;
        }

        void cacheMostSpecificTypes(TypeList key, Model model) {
            this.mostSpecificTypes.put(key, new TypeList(model, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType")));
        }

        Model getMostSpecificTypesToModel(TypeList key, Resource individual) {
            TypeList types = this.mostSpecificTypes.get(key);
            if (types != null) {
                return types.constructModel(individual, "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType");
            }
            return null;
        }
    }
}

