/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchResultDocument;
import java.util.Iterator;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;

public class SolrSearchResultDocumentList
implements SearchResultDocumentList {
    private SolrDocumentList solrDocs;

    public SolrSearchResultDocumentList(SolrDocumentList solrDocs) {
        if (solrDocs == null) {
            SolrDocumentList list = new SolrDocumentList();
            list.setStart(0L);
            list.setNumFound(0L);
            list.setMaxScore(Float.valueOf(0.0f));
            this.solrDocs = list;
        } else {
            this.solrDocs = solrDocs;
        }
    }

    @Override
    public Iterator<SearchResultDocument> iterator() {
        return new SearchResultDocumentIterator(this.solrDocs.iterator());
    }

    @Override
    public long getNumFound() {
        return this.solrDocs.getNumFound();
    }

    @Override
    public int size() {
        return this.solrDocs.size();
    }

    @Override
    public SearchResultDocument get(int i) {
        return SolrSearchResultDocumentList.convertToSearchResultDocument((SolrDocument)this.solrDocs.get(i));
    }

    private static SearchResultDocument convertToSearchResultDocument(SolrDocument solrDoc) {
        return new BaseSearchResultDocument((String)solrDoc.getFieldValue("DocId"), solrDoc.getFieldValuesMap());
    }

    private static class SearchResultDocumentIterator
    implements Iterator<SearchResultDocument> {
        private final Iterator<SolrDocument> solrIterator;

        public SearchResultDocumentIterator(Iterator<SolrDocument> solrIterator) {
            this.solrIterator = solrIterator;
        }

        @Override
        public boolean hasNext() {
            return this.solrIterator.hasNext();
        }

        @Override
        public SearchResultDocument next() {
            return SolrSearchResultDocumentList.convertToSearchResultDocument(this.solrIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

