/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class TBoxChanges {
    private final List<Statement> addedStatements = Collections.synchronizedList(new ArrayList());
    private final List<Statement> removedStatements = Collections.synchronizedList(new ArrayList());
    private final List<String> deletedDataPropertyUris = Collections.synchronizedList(new ArrayList());
    private final List<String> deletedObjectPropertyUris = Collections.synchronizedList(new ArrayList());

    public void addStatement(Statement stmt) {
        this.addedStatements.add(stmt);
    }

    public void removeStatement(Statement stmt) {
        this.removedStatements.add(stmt);
    }

    public void deleteDataProperty(Statement stmt) {
        Resource subject = stmt.getSubject();
        if (subject.isURIResource()) {
            this.deletedDataPropertyUris.add(subject.getURI());
        }
    }

    public void deleteObjectProperty(Statement stmt) {
        Resource subject = stmt.getSubject();
        if (subject.isURIResource()) {
            this.deletedObjectPropertyUris.add(subject.getURI());
        }
    }

    public boolean isEmpty() {
        return this.addedStatements.isEmpty() && this.removedStatements.isEmpty() && this.deletedDataPropertyUris.isEmpty() && this.deletedObjectPropertyUris.isEmpty();
    }

    public List<Statement> getAddedStatements() {
        return this.addedStatements;
    }

    public List<Statement> getRemovedStatements() {
        return this.removedStatements;
    }

    public List<String> getDeletedDataPropertyUris() {
        return this.deletedDataPropertyUris;
    }

    public List<String> getDeletedObjectPropertyUris() {
        return this.deletedObjectPropertyUris;
    }

    public String toString() {
        return "TBoxChanges[addedStatements=" + this.addedStatements + ", removedStatements=" + this.removedStatements + ", deletedDataPropertyUris=" + this.deletedDataPropertyUris + ", deletedObjectPropertyUris=" + this.deletedObjectPropertyUris + "]";
    }
}

