/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.LimitRemovalsToLanguage;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Test;
import org.testng.Assert;

public class LimitRemovalsToLanguageTest
extends AbstractTestClass {
    @Test
    public void testPreprocess() {
        LimitRemovalsToLanguage preproc = new LimitRemovalsToLanguage("en-US");
        Model additions = ModelFactory.createDefaultModel();
        Model retractions = ModelFactory.createDefaultModel();
        Resource res = ResourceFactory.createResource((String)"http://example.com/i/n1");
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US"));
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es1", (String)"es"));
        additions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US2", (String)"en-US"));
        preproc.preprocess(retractions, additions, null);
        Assert.assertEquals((long)retractions.size(), (long)1L);
        Assert.assertTrue((boolean)retractions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US")));
        Assert.assertEquals((long)additions.size(), (long)1L);
        Assert.assertTrue((boolean)additions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US2", (String)"en-US")));
        additions.removeAll();
        retractions.removeAll();
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US"));
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es1", (String)"es"));
        preproc.preprocess(retractions, additions, null);
        Assert.assertEquals((long)retractions.size(), (long)2L);
        Assert.assertTrue((boolean)retractions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US")));
        Assert.assertTrue((boolean)retractions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es1", (String)"es")));
        Assert.assertEquals((long)additions.size(), (long)0L);
        additions.removeAll();
        retractions.removeAll();
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US"));
        retractions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es1", (String)"es"));
        additions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US2", (String)"en-US"));
        additions.add(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es2", (String)"es"));
        preproc.preprocess(retractions, additions, null);
        Assert.assertEquals((long)retractions.size(), (long)2L);
        Assert.assertTrue((boolean)retractions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US1", (String)"en-US")));
        Assert.assertTrue((boolean)retractions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es1", (String)"es")));
        Assert.assertEquals((long)additions.size(), (long)2L);
        Assert.assertTrue((boolean)additions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"en-US2", (String)"en-US")));
        Assert.assertTrue((boolean)additions.contains(res, RDFS.label, (RDFNode)ResourceFactory.createLangLiteral((String)"es2", (String)"es")));
        additions.removeAll();
        retractions.removeAll();
    }
}

