/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdatingModelTest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.Arrays;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.junit.Test;

public class BulkUpdatingModelTest
extends AbstractBulkUpdatingModelTest {
    @Test
    public void testRemoveWithIterator() {
        BulkUpdatingModel wrappedModel = this.getWrappedModel();
        Model removeModel = VitroModelFactory.createModel();
        removeModel.add((Statement)this.getStatement());
        wrappedModel.remove(removeModel.listStatements());
    }

    @Test
    public void testRemoveStatementArray() {
        BulkUpdatingModel wrapModel = this.getWrappedModel();
        wrapModel.remove(new Statement[]{this.getStatement()});
    }

    @Test
    public void testRemoveStatementList() {
        BulkUpdatingModel wrapModel = this.getWrappedModel();
        wrapModel.remove(Arrays.asList(this.getStatement()));
    }

    @Test
    public void testAddWithIterator() {
        BulkUpdatingModel wrappedModel = this.getWrappedModel();
        Model model = VitroModelFactory.createModel();
        model.add((Statement)this.getStatement());
        wrappedModel.add(model.listStatements());
    }

    @Test
    public void testAddStatementArray() {
        BulkUpdatingModel wrapModel = this.getWrappedModel();
        wrapModel.add(new Statement[]{this.getStatement()});
    }

    @Test
    public void testAddStatementList() {
        BulkUpdatingModel wrapModel = this.getWrappedModel();
        wrapModel.add(Arrays.asList(this.getStatement()));
    }

    private BulkUpdatingModel getWrappedModel() {
        Model m = ModelFactory.createDefaultModel();
        RDFServiceModel rdfService = new RDFServiceModel(m);
        RDFServiceGraph g = new RDFServiceGraph((RDFService)rdfService);
        BulkUpdatingModel wrappedModel = new BulkUpdatingModel(RDFServiceGraph.createRDFServiceModel((RDFServiceGraph)g));
        wrappedModel.updater = new AbstractBulkUpdatingModelTest.WrappedUpdater(wrappedModel.updater);
        return wrappedModel;
    }
}

