/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderTestBase;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import java.util.Set;
import org.apache.jena.rdf.model.Statement;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationBeanLoader_Cardinality_Test
extends ConfigurationBeanLoaderTestBase {
    private static final Statement[] FOUND_NONE = new Statement[0];
    private static final Statement[] FOUND_ONE = new Statement[]{ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value One")};
    private static final Statement[] FOUND_TWO = new Statement[]{ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value One"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Two")};
    private static final Statement[] FOUND_THREE = new Statement[]{ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value One"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Two"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Three")};
    private static final Statement[] FOUND_FOUR = new Statement[]{ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value One"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Two"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Three"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "value Four")};

    @Test
    public void minOccursIsNegative_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NegativeMinOccurs.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "http://some.other/uri"));
        this.expectSimpleFailure(NegativeMinOccurs.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "must not be negative"));
    }

    @Test
    public void maxOccursLessThanMinOccurs_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(MaxOccursLessThanMinOccurs.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "http://some.other/uri"));
        this.expectSimpleFailure(MaxOccursLessThanMinOccurs.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "not be less than minOccurs"));
    }

    @Test
    public void expectingSomeFoundNone_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingSome.class)));
        this.model.add(FOUND_NONE);
        this.expectSimpleFailure(ExpectingSome.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.CardinalityException.class, "Expecting at least 2"));
    }

    @Test
    public void expectingSomeFoundFewer_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingSome.class)));
        this.model.add(FOUND_ONE);
        this.expectSimpleFailure(ExpectingSome.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.CardinalityException.class, "Expecting at least 2"));
    }

    @Test
    public void expectingSomeFoundMore_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingSome.class)));
        this.model.add(FOUND_FOUR);
        this.expectSimpleFailure(ExpectingSome.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.CardinalityException.class, "Expecting no more than 3"));
    }

    @Test
    public void expectingSomeFoundSome_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingSome.class)));
        this.model.add(FOUND_THREE);
        Set instances = this.loader.loadAll(ExpectingSome.class);
        Assert.assertEquals((long)1L, (long)instances.size());
        this.model.removeAll();
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingSome.class)));
        this.model.add(FOUND_TWO);
        instances = this.loader.loadAll(ExpectingSome.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void notSpecifiedFoundNone_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(CardinalityNotSpecified.class)));
        this.model.add(FOUND_NONE);
        Set instances = this.loader.loadAll(CardinalityNotSpecified.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void notSpecifiedFoundSome_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(CardinalityNotSpecified.class)));
        this.model.add(FOUND_FOUR);
        Set instances = this.loader.loadAll(CardinalityNotSpecified.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void expectNoneFoundNone_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectNone.class)));
        this.model.add(FOUND_NONE);
        Set instances = this.loader.loadAll(ExpectNone.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void expectExactlyFoundExactly_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectTwo.class)));
        this.model.add(FOUND_TWO);
        Set instances = this.loader.loadAll(ExpectTwo.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    public static class ExpectTwo {
        @Property(uri="http://mytest.edu/some_property", minOccurs=2, maxOccurs=2)
        public void setValue(String value) {
        }
    }

    public static class ExpectNone {
        @Property(uri="http://mytest.edu/some_property", maxOccurs=0)
        public void setValue(String value) {
        }
    }

    public static class CardinalityNotSpecified {
        @Property(uri="http://mytest.edu/some_property")
        public void setValue(String value) {
        }
    }

    public static class ExpectingSome {
        @Property(uri="http://mytest.edu/some_property", minOccurs=2, maxOccurs=3)
        public void setValue(String value) {
        }
    }

    public static class MaxOccursLessThanMinOccurs {
        @Property(uri="http://mytest.edu/some_property", minOccurs=2, maxOccurs=1)
        public void setValue(String value) {
        }
    }

    public static class NegativeMinOccurs {
        @Property(uri="http://mytest.edu/some_property", minOccurs=-1)
        public void setValue(String value) {
        }
    }
}

