/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dump;

import freemarker.core.Environment;
import freemarker.ext.dump.BaseDumpDirective;
import freemarker.ext.dump.DumpAllDirective;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DumpAllDirectiveTest {
    private Template template;

    @Before
    public void setUp() {
        Configuration config = new Configuration();
        String templateStr = "";
        try {
            this.template = new Template("template", (Reader)new StringReader(templateStr), config);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Logger.getLogger(BaseDumpDirective.class).setLevel(Level.OFF);
    }

    @Test
    public void dumpDataModel() {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String stringName = "dog";
        String stringVal = "Rover";
        dataModel.put(stringName, stringVal);
        String boolName = "isLoggedIn";
        boolean boolVal = true;
        dataModel.put(boolName, boolVal);
        String intName = "tabCount";
        int intVal = 7;
        dataModel.put(intName, intVal);
        String dateName = "now";
        Date dateVal = new Date();
        dataModel.put(dateName, dateVal);
        String listName = "fruit";
        ArrayList<String> listVal = new ArrayList<String>();
        listVal.add("apples");
        listVal.add("bananas");
        listVal.add("oranges");
        dataModel.put(listName, listVal);
        TreeMap expectedDump = new TreeMap();
        HashMap<String, Object> expectedStringDump = new HashMap<String, Object>();
        expectedStringDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
        expectedStringDump.put(BaseDumpDirective.Key.VALUE.toString(), stringVal);
        expectedDump.put(stringName, expectedStringDump);
        HashMap<String, Object> expectedBoolDump = new HashMap<String, Object>();
        expectedBoolDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
        expectedBoolDump.put(BaseDumpDirective.Key.VALUE.toString(), boolVal);
        expectedDump.put(boolName, expectedBoolDump);
        HashMap<String, Object> expectedIntDump = new HashMap<String, Object>();
        expectedIntDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
        expectedIntDump.put(BaseDumpDirective.Key.VALUE.toString(), intVal);
        expectedDump.put(intName, expectedIntDump);
        HashMap<String, Object> expectedDateDump = new HashMap<String, Object>();
        expectedDateDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDateDump.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
        expectedDateDump.put(BaseDumpDirective.Key.VALUE.toString(), dateVal);
        expectedDump.put(dateName, expectedDateDump);
        HashMap<String, Object> expectedListDump = new HashMap<String, Object>();
        expectedListDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList listItemsExpectedDump = new ArrayList(listVal.size());
        for (String str : listVal) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), str);
            listItemsExpectedDump.add(itemDump);
        }
        expectedListDump.put(BaseDumpDirective.Key.VALUE.toString(), listItemsExpectedDump);
        expectedDump.put(listName, expectedListDump);
        SortedMap<String, Object> dump = this.getDump(dataModel);
        Assert.assertEquals(expectedDump, dump);
        ArrayList expectedKeys = new ArrayList(expectedDump.keySet());
        ArrayList<String> actualKeys = new ArrayList<String>(dump.keySet());
        Assert.assertEquals(expectedKeys, actualKeys);
    }

    private SortedMap<String, Object> getDump(Map<String, Object> dataModel) {
        try {
            Environment env = this.template.createProcessingEnvironment(dataModel, (Writer)new StringWriter());
            return new DumpAllDirective().getDataModelDump(env);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

