/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import org.apache.jena.ontology.OntModel;

public abstract class AbstractDataPropertyStatementAction
extends AbstractPropertyStatementAction {
    private final String subjectUri;
    private final String predicateUri;
    private final Property predicate;
    private final String dataValue;

    public AbstractDataPropertyStatementAction(OntModel ontModel, String subjectUri, String predicateUri, String dataValue) {
        super(ontModel);
        this.subjectUri = subjectUri;
        this.predicateUri = predicateUri;
        Property dataProperty = new Property();
        dataProperty.setURI(predicateUri);
        this.predicate = dataProperty;
        this.dataValue = dataValue;
    }

    public AbstractDataPropertyStatementAction(OntModel ontModel, DataPropertyStatement dps) {
        super(ontModel);
        this.subjectUri = dps.getIndividual() == null ? dps.getIndividualURI() : dps.getIndividual().getURI();
        this.predicateUri = dps.getDatapropURI();
        Property dataProperty = new Property();
        dataProperty.setURI(this.predicateUri);
        this.predicate = dataProperty;
        this.dataValue = dps.getData();
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    @Override
    public Property getPredicate() {
        return this.predicate;
    }

    @Override
    public String getPredicateUri() {
        return this.predicateUri;
    }

    @Override
    public String[] getResourceUris() {
        return new String[]{this.subjectUri};
    }

    public String dataValue() {
        return this.dataValue;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": <" + this.subjectUri + "> <" + this.predicateUri + ">";
    }
}

