/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="programLogin", urlPatterns={"/programLogin"})
public class ProgramLogin
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ProgramLogin.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            new ProgramLoginCore(req, resp).process();
        }
        catch (Authenticator.LoginNotPermitted e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    static class ProgramLoginCore {
        public static final String PARAM_EMAIL_ADDRESS = "email";
        public static final String PARAM_PASSWORD = "password";
        public static final String PARAM_NEW_PASSWORD = "newPassword";
        public static final int ERROR_CODE = 403;
        private static final String MESSAGE_NEED_EMAIL_ADDRESS = "email parameter is required.";
        private static final String MESSAGE_NEED_PASSWORD = "password parameter is required.";
        private static final String MESSAGE_WRONG_USER_OR_PASSWORD = "email or password is incorrect.";
        private static final String MESSAGE_LOGIN_DISABLED = "User logins are temporarily disabled while the system is being maintained.";
        private static final String MESSAGE_NEED_NEW_PASSWORD = "first-time login: newPassword parameter is required.";
        private static final String MESSAGE_NEW_PASSWORD_NOT_NEEDED = "not first-time login: newPassword parameter is not allowed.";
        private static final String MESSAGE_NEW_PASSWORD_WRONG_LENGTH = "newPassword must be between 6 and 64 characters.";
        private static final String MESSAGE_PASSWORD_MUST_BE_DIFFERENT = "newPassword must not be the same as password";
        private static final String MESSAGE_SUCCESS_FIRST_TIME = "first-time login successful.";
        private static final String MESSAGE_SUCCESS = "login successful.";
        private final HttpServletRequest req;
        private final HttpServletResponse resp;
        private final Authenticator auth;
        private final String emailAddress;
        private final String password;
        private final String newPassword;
        private final UserAccount userAccount;

        ProgramLoginCore(HttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
            this.emailAddress = this.getParameter(PARAM_EMAIL_ADDRESS);
            this.password = this.getParameter(PARAM_PASSWORD);
            this.newPassword = this.getParameter(PARAM_NEW_PASSWORD);
            log.debug((Object)("request: email='" + this.emailAddress + "', password='" + this.password + "', newPassword='" + this.newPassword + "'"));
            this.auth = Authenticator.getInstance(req);
            this.userAccount = this.auth.getAccountForInternalAuth(this.emailAddress);
        }

        void process() throws IOException, Authenticator.LoginNotPermitted {
            if (this.emailAddress.isEmpty()) {
                this.sendError(MESSAGE_NEED_EMAIL_ADDRESS);
                return;
            }
            if (this.password.isEmpty()) {
                this.sendError(MESSAGE_NEED_PASSWORD);
                return;
            }
            if (!this.usernameAndPasswordAreValid()) {
                this.sendError(MESSAGE_WRONG_USER_OR_PASSWORD);
                return;
            }
            if (this.loginDisabled()) {
                this.sendError(MESSAGE_LOGIN_DISABLED);
                return;
            }
            if (!this.isPasswordChangeRequired()) {
                if (!this.newPassword.isEmpty()) {
                    this.sendError(MESSAGE_NEW_PASSWORD_NOT_NEEDED);
                    return;
                }
                this.recordLogin();
                this.sendSuccess(MESSAGE_SUCCESS);
                return;
            }
            if (this.isPasswordChangeRequired()) {
                if (this.newPassword.isEmpty()) {
                    this.sendError(MESSAGE_NEED_NEW_PASSWORD);
                    return;
                }
                if (!this.newPasswordIsValidPasswordLength()) {
                    this.sendError(MESSAGE_NEW_PASSWORD_WRONG_LENGTH);
                    return;
                }
                if (this.newPasswordMatchesCurrentPassword()) {
                    this.sendError(MESSAGE_PASSWORD_MUST_BE_DIFFERENT);
                    return;
                }
                this.recordLoginWithPasswordChange();
                this.sendSuccess(MESSAGE_SUCCESS_FIRST_TIME);
            }
        }

        private String getParameter(String key) {
            String value = this.req.getParameter(key);
            if (value != null) {
                return value.trim();
            }
            return "";
        }

        private boolean usernameAndPasswordAreValid() {
            if (this.auth.md5HashIsNull(this.userAccount)) {
                if (!this.auth.isCurrentPasswordArgon2(this.userAccount, this.password)) {
                    return false;
                }
            } else {
                if (!this.auth.isCurrentPassword(this.userAccount, this.password)) {
                    return false;
                }
                this.userAccount.setPasswordChangeRequired(true);
            }
            return true;
        }

        private boolean loginDisabled() {
            return !this.auth.isUserPermittedToLogin(this.userAccount);
        }

        private boolean newPasswordIsValidPasswordLength() {
            return this.newPassword.length() >= 6 && this.newPassword.length() <= 64;
        }

        private boolean newPasswordMatchesCurrentPassword() {
            return this.newPassword.equals(this.password);
        }

        private boolean isPasswordChangeRequired() {
            return this.userAccount.isPasswordChangeRequired();
        }

        private void recordLogin() throws Authenticator.LoginNotPermitted {
            this.auth.recordLoginAgainstUserAccount(this.userAccount, LoginStatusBean.AuthenticationSource.INTERNAL);
        }

        private void recordLoginWithPasswordChange() throws Authenticator.LoginNotPermitted {
            this.auth.recordNewPassword(this.userAccount, this.newPassword);
            this.auth.recordLoginAgainstUserAccount(this.userAccount, LoginStatusBean.AuthenticationSource.INTERNAL);
        }

        private void sendError(String message) throws IOException {
            this.resp.sendError(403, message);
        }

        private void sendSuccess(String message) throws IOException {
            PrintWriter writer = this.resp.getWriter();
            writer.println(message);
        }
    }
}

