/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.Validator;
import edu.cornell.mannlib.vedit.validator.impl.RequiredFieldValidator;
import edu.cornell.mannlib.vedit.validator.impl.UrlValidator;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)OntologyRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        Ontology testMask = new Ontology();
        epo.setBeanClass(Ontology.class);
        epo.setBeanMask(testMask);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        OntologyDao oDao = request.getUnfilteredWebappDaoFactory().getOntologyDao();
        epo.setDataAccessObject(oDao);
        Ontology ontologyForEditing = null;
        if (!epo.getUseRecycledBean()) {
            if (request.getParameter("uri") != null) {
                try {
                    ontologyForEditing = oDao.getOntologyByURI(request.getParameter("uri"));
                    action = "update";
                }
                catch (NullPointerException e) {
                    log.error((Object)("No ontology record found for the namespace " + request.getParameter("uri")));
                }
            } else {
                ontologyForEditing = new Ontology();
            }
            epo.setOriginalBean(ontologyForEditing);
        } else {
            ontologyForEditing = (Ontology)epo.getNewBean();
        }
        ArrayList<Validator> validatorList = new ArrayList<Validator>();
        validatorList.add(new RequiredFieldValidator());
        validatorList.add(new UrlValidator());
        epo.getValidatorMap().put("URI", validatorList);
        Object[] simpleMaskPair = new Object[]{"Id", ontologyForEditing.getId()};
        epo.getSimpleMask().add(simpleMaskPair);
        epo.setPostInsertPageForwarder(new OntologyInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder("listOntologies"));
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(oDao.getClass().getDeclaredMethod("getOntologyByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"OntologyRetryController could not find the getOntologyByURI method in the DAO");
        }
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(ontologyForEditing, action, foo, epo.getBadValueMap());
        request.setAttribute("formJsp", "/templates/edit/specific/ontology_retry.jsp");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("title", "Ontology Editing Form");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "Ontology");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"OntologyRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class OntologyInsertPageForwarder
    implements PageForwarder {
        OntologyInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newOntologyUrl = "ontologyEdit?uri=";
            Ontology ont = (Ontology)epo.getNewBean();
            try {
                newOntologyUrl = newOntologyUrl + URLEncoder.encode(ont.getURI(), "UTF-8");
                response.sendRedirect(newOntologyUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"OntologyInsertPageForwarder could not send redirect.");
            }
        }
    }
}

