/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class RestrictionRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)RestrictionRetryController.class.getName());
    private static final boolean DATA = true;
    private static final boolean OBJECT = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        try {
            void var10_20;
            EditProcessObject epo = this.createEpo((HttpServletRequest)request);
            request.setAttribute("editAction", "addRestriction");
            epo.setAttribute("VClassURI", request.getParameter("VClassURI"));
            String restrictionTypeStr = request.getParameter("restrictionType");
            epo.setAttribute("restrictionType", restrictionTypeStr);
            request.setAttribute("restrictionType", restrictionTypeStr);
            boolean propertyType = "data".equals(request.getParameter("propertyType"));
            List<Property> pList = !propertyType ? request.getUnfilteredWebappDaoFactory().getObjectPropertyDao().getAllObjectProperties() : request.getUnfilteredWebappDaoFactory().getDataPropertyDao().getAllDataProperties();
            LinkedList<Option> onPropertyList = new LinkedList<Option>();
            this.sortForPickList(pList, request);
            for (ResourceBean resourceBean : pList) {
                onPropertyList.add(new Option(resourceBean.getURI(), resourceBean.getPickListName()));
            }
            epo.setFormObject(new FormObject());
            epo.getFormObject().getOptionLists().put("onProperty", onPropertyList);
            String string = restrictionTypeStr;
            int n = -1;
            switch (string.hashCode()) {
                case -672073728: {
                    if (!string.equals("someValuesFrom")) break;
                    boolean bl = false;
                    break;
                }
                case 1622427757: {
                    if (!string.equals("allValuesFrom")) break;
                    boolean bl = true;
                    break;
                }
                case 131964663: {
                    if (!string.equals("hasValue")) break;
                    int n2 = 2;
                    break;
                }
                case -481548324: {
                    if (!string.equals("minCardinality")) break;
                    int n3 = 3;
                    break;
                }
                case -1138464374: {
                    if (!string.equals("maxCardinality")) break;
                    int n4 = 4;
                    break;
                }
                case 845213070: {
                    if (!string.equals("cardinality")) break;
                    int n5 = 5;
                }
            }
            switch (var10_20) {
                case 0: {
                    request.setAttribute("specificRestrictionForm", "someValuesFromRestriction_retry.jsp");
                    List<Option> optionList = !propertyType ? this.getValueClassOptionList(request) : this.getValueDatatypeOptionList(request);
                    epo.getFormObject().getOptionLists().put("ValueClass", optionList);
                    break;
                }
                case 1: {
                    request.setAttribute("specificRestrictionForm", "allValuesFromRestriction_retry.jsp");
                    List<Option> optionList = !propertyType ? this.getValueClassOptionList(request) : this.getValueDatatypeOptionList(request);
                    epo.getFormObject().getOptionLists().put("ValueClass", optionList);
                    break;
                }
                case 2: {
                    request.setAttribute("specificRestrictionForm", "hasValueRestriction_retry.jsp");
                    if (!propertyType) {
                        request.setAttribute("propertyType", "object");
                        break;
                    }
                    request.setAttribute("propertyType", "data");
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    request.setAttribute("specificRestrictionForm", "cardinalityRestriction_retry.jsp");
                }
            }
            request.setAttribute("formJsp", "/templates/edit/specific/restriction_retry.jsp");
            request.setAttribute("scripts", "/templates/edit/formBasic.js");
            request.setAttribute("title", "Add Restriction");
            request.setAttribute("_action", "insert");
            this.setRequestAttributes((HttpServletRequest)request, epo);
            try {
                JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
            }
            catch (Exception e) {
                log.error((Object)(this.getClass().getName() + "PropertyRetryController could not forward to view."));
                log.error((Object)e.getMessage());
                log.error((Object)e.getStackTrace());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Option> getValueClassOptionList(VitroRequest request) {
        LinkedList<Option> valueClassOptionList = new LinkedList<Option>();
        VClassDao vcDao = request.getUnfilteredWebappDaoFactory().getVClassDao();
        List<VClass> vclasses = vcDao.getAllVclasses();
        boolean addOwlThing = true;
        for (VClass vclass : vclasses) {
            if (!OWL.Thing.getURI().equals(vclass.getURI())) continue;
            addOwlThing = false;
            break;
        }
        if (addOwlThing) {
            vclasses.add(new VClass(OWL.Thing.getURI()));
        }
        Collections.sort(vclasses);
        for (VClass vc : vclasses) {
            valueClassOptionList.add(new Option(vc.getURI(), vc.getPickListName()));
        }
        return valueClassOptionList;
    }

    private List<Option> getValueDatatypeOptionList(VitroRequest request) {
        LinkedList<Option> valueDatatypeOptionList = new LinkedList<Option>();
        DatatypeDao dtDao = request.getUnfilteredWebappDaoFactory().getDatatypeDao();
        for (Datatype dt : dtDao.getAllDatatypes()) {
            valueDatatypeOptionList.add(new Option(dt.getUri(), dt.getName()));
        }
        valueDatatypeOptionList.add(new Option(RDFS.Literal.getURI(), "rdfs:Literal"));
        return valueDatatypeOptionList;
    }
}

