/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.rel17;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.update.GraphStore;
import org.apache.jena.update.GraphStoreFactory;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class RemoveObsoletePermissions
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(RemoveObsoletePermissions.class);
    static final String[] OBSOLETE_PERMISSIONS = new String[]{"java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#RebuildVClassGroupCache", "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#ManageTabs", "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#UseMiscellaneousEditorPages", "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#ManagePortals"};
    static final String UPDATE_TEMPLATE = "DELETE WHERE { \n  GRAPH <http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts> {\n    ?s ?p <%s> .\n  } \n}";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            Updater updater = new Updater(ctx);
            updater.update();
            if (updater.statementsRemoved() == 0L) {
                ss.info(this, "User accounts model contained no statements referencing obsolete permissions.");
            } else {
                ss.info(this, String.format("Adjusted the user accounts model. Removed %s statements referencing %s obsolete permissions.", updater.statementsRemoved(), OBSOLETE_PERMISSIONS.length));
            }
        }
        catch (Exception e) {
            ss.fatal(this, "Failed to update URIs of PermissionSets on User Accounts", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private static class Updater {
        private final ServletContext ctx;
        private long statementsRemoved;

        public Updater(ServletContext ctx) {
            this.ctx = ctx;
        }

        public void update() {
            OntModel model = ModelAccess.on(this.ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts");
            long statementsAtStart = model.size();
            RDFService rdfService = ModelAccess.on(this.ctx).getRDFService(ModelAccess.WhichService.CONFIGURATION);
            for (String permissionUri : OBSOLETE_PERMISSIONS) {
                this.removeStatements(rdfService, permissionUri);
            }
            this.statementsRemoved = statementsAtStart - model.size();
        }

        private void removeStatements(RDFService rdfService, String permissionUri) {
            String updateString = String.format(RemoveObsoletePermissions.UPDATE_TEMPLATE, permissionUri);
            log.debug((Object)updateString);
            UpdateRequest parsed = UpdateFactory.create((String)updateString);
            RDFServiceDataset ds = new RDFServiceDataset(rdfService);
            GraphStore graphStore = GraphStoreFactory.create((Dataset)ds);
            UpdateAction.execute((UpdateRequest)parsed, (DatasetGraph)graphStore);
        }

        public long statementsRemoved() {
            return this.statementsRemoved;
        }
    }
}

