/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import edu.cornell.mannlib.vitro.webapp.search.controller.IndexHistory;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingServiceSetup;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="IndexController", urlPatterns={"/SearchIndex"})
public class IndexController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(IndexController.class);
    private static final String PAGE_URL = "/SearchIndex";
    private static final String PAGE_TEMPLATE_NAME = "searchIndex.ftl";
    private static final String STATUS_TEMPLATE_NAME = "searchIndexStatus.ftl";
    public static final RequestedAction REQUIRED_ACTIONS = SimplePermission.MANAGE_SEARCH_INDEX.ACTION;
    private SearchIndexer indexer;
    private static IndexHistory history;

    public void init() throws ServletException {
        this.indexer = ApplicationUtils.instance().getSearchIndexer();
        super.init();
    }

    public static void setHistory(IndexHistory history) {
        IndexController.history = history;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        switch (RequestType.fromRequest(req)) {
            case STATUS: {
                this.showStatus(req, resp);
                break;
            }
            default: {
                super.doGet(req, resp);
            }
        }
    }

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        return "Rebuild Search Index";
    }

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return REQUIRED_ACTIONS;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        switch (RequestType.fromRequest((HttpServletRequest)vreq)) {
            case REBUILD: {
                this.requestRebuild();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return new RedirectResponseValues(PAGE_URL);
            }
        }
        return this.showDisplay();
    }

    private ResponseValues showDisplay() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("statusUrl", UrlBuilder.getUrl(PAGE_URL, "status", "true"));
        body.put("rebuildUrl", UrlBuilder.getUrl(PAGE_URL, "rebuild", "true"));
        return new TemplateResponseValues(PAGE_TEMPLATE_NAME, body);
    }

    private void showStatus(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!PolicyHelper.isAuthorizedForActions(req, new AuthorizationRequest[]{REQUIRED_ACTIONS})) {
            resp.setStatus(403);
            resp.getWriter().write("You are not authorized to access this page.");
            return;
        }
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("statusUrl", UrlBuilder.getUrl(PAGE_URL, "status", "true"));
            body.put("rebuildUrl", UrlBuilder.getUrl(PAGE_URL, "rebuild", "true"));
            body.put("status", this.buildStatusMap(this.indexer.getStatus()));
            if (history != null) {
                body.put("history", history.toMaps());
            }
            String rendered = FreemarkerProcessingServiceSetup.getService(this.getServletContext()).renderTemplate(STATUS_TEMPLATE_NAME, body, req);
            resp.getWriter().write(rendered);
        }
        catch (Exception e) {
            resp.setStatus(500);
            resp.getWriter().write(e.toString());
            log.error((Object)e, (Throwable)e);
        }
    }

    private void requestRebuild() {
        this.indexer.rebuildIndex();
    }

    private Map<String, Object> buildStatusMap(SearchIndexerStatus status) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SearchIndexerStatus.State state = status.getState();
        map.put("statusType", (Object)state);
        map.put("since", status.getSince());
        if (state == SearchIndexerStatus.State.PROCESSING_URIS) {
            SearchIndexerStatus.UriCounts counts = status.getCounts().asUriCounts();
            map.put("updated", counts.getUpdated());
            map.put("deleted", counts.getDeleted());
            map.put("remaining", counts.getRemaining());
            map.put("total", counts.getTotal());
            map.put("elapsed", this.breakDownElapsedTime(status.getSince()));
            map.put("expectedCompletion", this.figureExpectedCompletion(status.getSince(), counts.getTotal(), counts.getTotal() - counts.getRemaining()));
        } else if (state == SearchIndexerStatus.State.PROCESSING_STMTS) {
            SearchIndexerStatus.StatementCounts counts = status.getCounts().asStatementCounts();
            map.put("processed", counts.getProcessed());
            map.put("remaining", counts.getRemaining());
            map.put("total", counts.getTotal());
            map.put("elapsed", this.breakDownElapsedTime(status.getSince()));
            map.put("expectedCompletion", this.figureExpectedCompletion(status.getSince(), counts.getTotal(), counts.getProcessed()));
        } else if (state == SearchIndexerStatus.State.REBUILDING) {
            SearchIndexerStatus.RebuildCounts counts = status.getCounts().asRebuildCounts();
            map.put("documentsBefore", counts.getDocumentsBefore());
            map.put("documentsAfter", counts.getDocumentsAfter());
        }
        return map;
    }

    private Date figureExpectedCompletion(Date startTime, long totalToDo, long completedCount) {
        Date now = new Date();
        long elapsedMillis = now.getTime() - startTime.getTime();
        if (elapsedMillis <= 0L) {
            return now;
        }
        if (completedCount <= 0L) {
            return now;
        }
        if (totalToDo <= completedCount) {
            return now;
        }
        long millisPerRecord = elapsedMillis / completedCount;
        long expectedDuration = totalToDo * millisPerRecord;
        return new Date(expectedDuration + startTime.getTime());
    }

    private int[] breakDownElapsedTime(Date since) {
        long elapsedMillis = new Date().getTime() - since.getTime();
        long seconds = elapsedMillis / 1000L % 60L;
        long minutes = elapsedMillis / 60000L % 60L;
        long hours = elapsedMillis / 3600000L;
        return new int[]{(int)hours, (int)minutes, (int)seconds};
    }

    private static enum RequestType {
        DISPLAY,
        STATUS,
        REBUILD;


        static RequestType fromRequest(HttpServletRequest req) {
            if (RequestType.hasParameter(req, "rebuild")) {
                return REBUILD;
            }
            if (RequestType.hasParameter(req, "status")) {
                return STATUS;
            }
            return DISPLAY;
        }

        private static boolean hasParameter(HttpServletRequest req, String key) {
            String value = req.getParameter(key);
            return value != null && !value.isEmpty();
        }
    }
}

