/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;

public class AdditionalURIsForClassGroupChanges
implements IndexingUriFinder,
ContextModelsUser {
    private OntModel model;

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.model = models.getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findAdditionalURIsToIndex(Statement stmt) {
        if (stmt != null && "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup".equals(stmt.getPredicate().getURI()) && stmt.getSubject() != null) {
            ArrayList<String> uris = new ArrayList<String>();
            this.model.enterCriticalSection(true);
            try {
                StmtIterator iter = this.model.listStatements(null, RDF.type, (RDFNode)stmt.getSubject());
                while (iter.hasNext()) {
                    Statement typeStmt = iter.nextStatement();
                    if (typeStmt == null || !typeStmt.getSubject().isURIResource()) continue;
                    uris.add(typeStmt.getSubject().getURI());
                }
            }
            finally {
                this.model.leaveCriticalSection();
            }
            return uris;
        }
        return Collections.emptyList();
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void endIndexing() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

