/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;

public class SelectQueryUriFinder
implements IndexingUriFinder,
ContextModelsUser {
    private static final Log log = LogFactory.getLog(SelectQueryUriFinder.class);
    private RDFService rdfService;
    private String label;
    private List<String> queries = new ArrayList<String>();
    private Set<String> predicateRestrictions = new HashSet<String>();

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.rdfService = models.getRDFService(ModelAccess.WhichService.CONTENT);
    }

    @Property(uri="http://www.w3.org/2000/01/rdf-schema#label")
    public void setLabel(String l) {
        this.label = l;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasSelectQuery", minOccurs=1)
    public void addQuery(String query) {
        this.queries.add(query);
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasPredicateRestriction")
    public void addPredicateRestriction(String predicateUri) {
        this.predicateRestrictions.add(predicateUri);
    }

    @Validation
    public void validate() {
        if (this.label == null) {
            this.label = this.getClass().getSimpleName() + ":" + this.hashCode();
        }
    }

    public String toString() {
        return this.label == null ? super.toString() : this.label;
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public List<String> findAdditionalURIsToIndex(Statement stmt) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.passesTypePredicateRestrictions(stmt)) {
            for (String query : this.queries) {
                list.addAll(this.getUrisForQuery(stmt, query));
            }
        }
        return list;
    }

    private boolean passesTypePredicateRestrictions(Statement stmt) {
        return this.predicateRestrictions.isEmpty() || this.predicateRestrictions.contains(stmt.getPredicate().getURI());
    }

    private List<String> getUrisForQuery(Statement stmt, String queryString) {
        QueryHolder query = SparqlQueryRunner.queryHolder(queryString);
        query = query.bindToUri("predicate", stmt.getPredicate().getURI());
        query = this.tryToBindUri(query, "subject", (RDFNode)stmt.getSubject());
        if ((query = this.tryToBindUri(query, "object", stmt.getObject())) == null) {
            return Collections.emptyList();
        }
        return SparqlQueryRunner.createSelectQueryContext(this.rdfService, query).execute().toStringFields(new String[0]).flatten();
    }

    private QueryHolder tryToBindUri(QueryHolder query, String name, RDFNode node) {
        if (query == null) {
            return null;
        }
        if (!query.hasVariable(name)) {
            return query;
        }
        if (!node.isURIResource()) {
            return null;
        }
        return query.bindToUri(name, node.asResource().getURI());
    }

    @Override
    public void endIndexing() {
    }
}

