/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class RDFFilesLoader {
    private static final Log log = LogFactory.getLog(RDFFilesLoader.class);
    private static final String DEFAULT_RDF_FORMAT = "RDF/XML";
    private static final String RDF = "rdf";
    private static final String I18N = "i18n";
    private static final String FIRST_TIME = "firsttime";
    private static final String EVERY_TIME = "everytime";
    private static final DirectoryStream.Filter<Path> RDF_FILE_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path p) throws IOException {
            if (Files.isHidden(p)) {
                return false;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                log.warn((Object)("RDF files in subdirectories are not loaded. Directory '" + p + "' ignored."));
                return false;
            }
            return !p.toString().endsWith(".md");
        }
    };

    public static void loadFirstTimeFiles(ServletContext ctx, String modelPath, Model model, boolean firstTime) {
        if (firstTime) {
            String home = RDFFilesLoader.locateHomeDirectory();
            Set<Path> paths = RDFFilesLoader.getPaths(home, RDF, modelPath, FIRST_TIME);
            Set<String> enabledLocales = RDFFilesLoader.getEnabledLocales(ctx);
            for (String locale : enabledLocales) {
                paths.addAll(RDFFilesLoader.getPaths(home, RDF, I18N, locale, modelPath, FIRST_TIME));
            }
            for (Path p : paths) {
                log.info((Object)("Loading " + RDFFilesLoader.relativePath(p, home)));
                RDFFilesLoader.readOntologyFileIntoModel(p, model);
            }
        } else {
            log.debug((Object)("Not loading first time files on '" + modelPath + "', firstTime=false"));
        }
    }

    public static void loadEveryTimeFiles(ServletContext ctx, String modelPath, OntModel model) {
        OntModel everytimeModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        String home = RDFFilesLoader.locateHomeDirectory();
        Set<Path> paths = RDFFilesLoader.getPaths(home, RDF, modelPath, EVERY_TIME);
        Set<String> enabledLocales = RDFFilesLoader.getEnabledLocales(ctx);
        for (String locale : enabledLocales) {
            paths.addAll(RDFFilesLoader.getPaths(home, RDF, I18N, locale, modelPath, EVERY_TIME));
        }
        for (Path p : paths) {
            log.info((Object)("Loading " + RDFFilesLoader.relativePath(p, home)));
            RDFFilesLoader.readOntologyFileIntoModel(p, (Model)everytimeModel);
        }
        model.addSubModel((Model)everytimeModel);
    }

    public static Set<String> getEnabledLocales(ServletContext ctx) {
        HashSet<String> enabledLocales = new HashSet<String>();
        List<Locale> locales = SelectedLocale.getSelectableLocales(ctx);
        for (Locale locale : locales) {
            String localeString = locale.toLanguageTag().replace('-', '_');
            if (!enabledLocales.contains(localeString)) {
                enabledLocales.add(localeString);
            }
            if (!locale.hasExtensions() || enabledLocales.contains(localeString = locale.stripExtensions().toLanguageTag().replace('-', '_'))) continue;
            enabledLocales.add(localeString);
        }
        if (enabledLocales.isEmpty()) {
            enabledLocales.add(SelectedLocale.getFallbackLocale().toString());
        }
        return enabledLocales;
    }

    private static Path relativePath(Path p, String home) {
        try {
            return Paths.get(home, new String[0]).relativize(p);
        }
        catch (Exception e) {
            return p;
        }
    }

    private static Set<Path> getPaths(String parentDir, String ... strings) {
        Path dir = Paths.get(parentDir, strings);
        TreeSet<Path> paths = new TreeSet<Path>();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, RDF_FILE_FILTER);){
                for (Path p : stream) {
                    paths.add(p);
                }
            }
            catch (IOException e) {
                log.warn((Object)("Failed to read directory '" + dir + "'"), (Throwable)e);
            }
        } else {
            log.debug((Object)("Directory '" + dir + "' doesn't exist."));
        }
        log.debug((Object)("Paths from '" + dir + "': " + paths));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readOntologyFileIntoModel(Path p, Model model) {
        String format = RDFFilesLoader.getRdfFormat(p);
        log.debug((Object)("Loading " + p));
        try (Model memModel = ModelFactory.createDefaultModel();
             FileInputStream stream = new FileInputStream(p.toFile());){
            memModel.read((InputStream)stream, null, format);
            model.add(memModel);
            log.debug((Object)"...successful");
        }
    }

    private static String getRdfFormat(Path p) {
        String filename = p.getFileName().toString().toLowerCase();
        if (filename.endsWith("n3")) {
            return "N3";
        }
        if (filename.endsWith("nt")) {
            return "N-TRIPLES";
        }
        if (filename.endsWith("ttl")) {
            return "TURTLE";
        }
        return DEFAULT_RDF_FORMAT;
    }

    private static String locateHomeDirectory() {
        return ApplicationUtils.instance().getHomeDirectory().getPath().toString();
    }

    private RDFFilesLoader() {
    }

    public static void removeChangesThatConflictWithUIEdits(Model baseModel, Model userModel, Model changesModel) {
        log.debug((Object)"Check if subtractions from backup-firsttime model to current state of firsttime-files were changed in user-model (via UI)");
        Model scopedUserModel = ModelFactory.createDefaultModel();
        StmtIterator scopeIt = changesModel.listStatements();
        while (scopeIt.hasNext()) {
            Statement scopingStmt = (Statement)scopeIt.next();
            scopedUserModel.add(userModel.listStatements(scopingStmt.getSubject(), scopingStmt.getPredicate(), (RDFNode)null));
        }
        log.debug((Object)("Scoped user model has " + scopedUserModel.size()));
        Model changesUserModel = scopedUserModel.difference(baseModel);
        log.debug((Object)("Diff of scoped user model against firsttime backup has " + changesUserModel.size() + " triples"));
        ArrayList<Statement> changedInUIandFileStatements = new ArrayList<Statement>();
        if (changesUserModel.isEmpty()) {
            log.debug((Object)"There were no changes in the user-model via UI compared to the backup-firsttime-model");
            return;
        }
        RDFFilesLoader.removeBlankTriples(changesUserModel);
        if (log.isDebugEnabled()) {
            StringWriter out3 = new StringWriter();
            changesUserModel.write((Writer)out3, "TTL");
            log.debug((Object)("changesUserModel:\n" + out3));
        }
        log.debug((Object)"There were changes in the user-model via UI which have also changed in the firsttime files. The following triples will not be updated.");
        StmtIterator userChanges = changesUserModel.listStatements();
        while (userChanges.hasNext()) {
            Statement stmt = userChanges.nextStatement();
            Resource subject = stmt.getSubject();
            Property predicate = stmt.getPredicate();
            RDFNode object = stmt.getObject();
            StmtIterator firsttimeChanges = changesModel.listStatements(subject, predicate, (RDFNode)null);
            while (firsttimeChanges.hasNext()) {
                Statement stmt2 = firsttimeChanges.nextStatement();
                RDFNode object2 = stmt2.getObject();
                if (object.equals(object2)) continue;
                if (object.isLiteral() && object2.isLiteral()) {
                    if (!object.asLiteral().getLanguage().equals(object2.asLiteral().getLanguage())) continue;
                    log.debug((Object)("This two triples changed UI and files: \n UI: " + stmt + " \n file: " + stmt2));
                    changedInUIandFileStatements.add(stmt2);
                    continue;
                }
                log.debug((Object)("This two triples changed UI and files: \n UI: " + stmt + " \n file: " + stmt2));
                changedInUIandFileStatements.add(stmt2);
            }
        }
        changesModel.remove(changedInUIandFileStatements);
    }

    public static void removeBlankTriples(Model model) {
        ArrayList<Statement> removeStatement = new ArrayList<Statement>();
        StmtIterator stmts = model.listStatements();
        while (stmts.hasNext()) {
            Statement stmt = stmts.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) continue;
            removeStatement.add(stmt);
        }
        model.remove(removeStatement);
    }

    public static boolean areIsomporphic(Model m1, Model m2) {
        boolean isIsomorphic = m1.isIsomorphicWith(m2);
        if (isIsomorphic) {
            return true;
        }
        Model diff1 = m1.difference(m2);
        Model diff2 = m2.difference(m1);
        RDFFilesLoader.removeBlankTriples(diff1);
        RDFFilesLoader.removeBlankTriples(diff2);
        return diff1.isEmpty() && diff2.isEmpty();
    }
}

