/* $This file is distributed under the terms of the license in LICENSE$ */

package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsUser;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;

/**
 * If the user is logged in, create an Identifier.
 */
public class IsUserFactory extends BaseUserBasedIdentifierBundleFactory {

	@Override
	public IdentifierBundle getIdentifierBundleForUser(UserAccount user) {
		if (user == null) {
			return new ArrayIdentifierBundle();
		} else {
			return new ArrayIdentifierBundle(new IsUser(user.getUri()));
		}
	}

}
