/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit;

import edu.cornell.mannlib.vitro.webapp.audit.AuditChangeSet;
import edu.cornell.mannlib.vitro.webapp.audit.AuditResults;
import edu.cornell.mannlib.vitro.webapp.audit.AuditSetup;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAO;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOFactory;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOTDB;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AuditDaoTDBTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private RDFService rdfService;

    @Before
    public void initializeModule() throws IOException {
        AuditDAOTDB.initialize((String)this.folder.getRoot().getAbsolutePath());
        AuditDAOFactory.initialize((AuditDAOFactory.Storage)AuditDAOFactory.Storage.AUDIT_TDB);
        Model model = ModelFactory.createDefaultModel();
        this.rdfService = new RDFServiceModel(model);
        AuditSetup auditSetup = new AuditSetup();
        auditSetup.registerChangeListener(this.rdfService);
    }

    @After
    public void closeModule() throws IOException {
        AuditDAOTDB.shutdown();
        AuditDAOFactory.shutdown();
    }

    @Test
    public void testInitialization() {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        Assert.assertNotNull((Object)dao);
    }

    @Test
    public void testGetGraphs() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        List graphList = dao.getGraphs();
        Assert.assertTrue((boolean)graphList.isEmpty());
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        graphList = dao.getGraphs();
        Assert.assertEquals((long)2L, (long)graphList.size());
        Assert.assertTrue((boolean)graphList.contains("http://vitro.mannlib.cornell.edu/default/vitro-kb-2"));
        Assert.assertTrue((boolean)graphList.contains("http://vitro.mannlib.cornell.edu/default/asserted-tbox"));
    }

    @Test
    public void testGetUsers() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        List userList = dao.getUsers();
        Assert.assertTrue((boolean)userList.isEmpty());
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        userList = dao.getUsers();
        Assert.assertEquals((long)2L, (long)userList.size());
        Assert.assertTrue((boolean)userList.contains("test:bob"));
        Assert.assertTrue((boolean)userList.contains("test:alice"));
    }

    @Test
    public void testFindWrongDate() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 10, 0L, 1L, "", "", false);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)0L, (long)datasets.size());
    }

    @Test
    public void testFindSpecificEditor() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 10, 0L, System.currentTimeMillis(), "test:bob", "", false);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)1L, (long)datasets.size());
        Assert.assertEquals((Object)"test:bob", (Object)((AuditChangeSet)datasets.get(0)).getUserId());
    }

    @Test
    public void testFindLimit() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 1, 0L, System.currentTimeMillis(), "", "", false);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)1L, (long)datasets.size());
    }

    @Test
    public void testFindDescOrder() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 10, 0L, System.currentTimeMillis(), "", "", false);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)2L, (long)datasets.size());
        Assert.assertEquals((Object)"test:alice", (Object)((AuditChangeSet)datasets.get(0)).getUserId());
    }

    @Test
    public void testFindAscOrder() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 10, 0L, System.currentTimeMillis(), "", "", true);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)2L, (long)datasets.size());
        Assert.assertEquals((Object)"test:bob", (Object)((AuditChangeSet)datasets.get(0)).getUserId());
    }

    @Test
    public void testFindSpecificGraph() throws Exception {
        AuditDAO dao = AuditDAOFactory.getAuditDAO();
        this.addData("42", "test:bob", "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", false);
        this.addData("77", "test:alice", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", true);
        AuditResults results = dao.find(0L, 10, 0L, System.currentTimeMillis(), "", "http://vitro.mannlib.cornell.edu/default/asserted-tbox", false);
        List datasets = results.getDatasets();
        Assert.assertEquals((long)1L, (long)datasets.size());
        Assert.assertEquals((long)1L, (long)((AuditChangeSet)datasets.get(0)).getGraphUris().size());
        Assert.assertEquals((Object)"http://vitro.mannlib.cornell.edu/default/asserted-tbox", ((AuditChangeSet)datasets.get(0)).getGraphUris().iterator().next());
    }

    public void addData(String propValue, String editorUri, String graphUri, boolean isAddition) throws Exception {
        ChangeSet cs = this.rdfService.manufactureChangeSet();
        String inputString = "<test:uri> <test:prop> \"" + propValue + "\" . ";
        try (ByteArrayInputStream stream = new ByteArrayInputStream(inputString.getBytes(StandardCharsets.UTF_8));){
            if (isAddition) {
                cs.addAddition((InputStream)stream, RDFService.ModelSerializationFormat.N3, graphUri, editorUri);
            } else {
                cs.addRemoval((InputStream)stream, RDFService.ModelSerializationFormat.N3, graphUri, editorUri);
            }
            this.rdfService.changeSetUpdate(cs);
        }
    }
}

