/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.MutableAttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.QueryResultsMapCache;
import edu.cornell.mannlib.vitro.webapp.auth.checks.SparqlSelectQueryResultsChecker;
import edu.cornell.mannlib.vitro.webapp.auth.checks.StatementObjectUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.NamedAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.rdf.model.Model;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;

public class SparqlSelectQueryResultsCheckerTest {
    private static final String SIMPLE_QUERY = "SELECT ?value WHERE {?subject ?property ?value .}";
    private static final String NOT_PRESENT_VALUE = "not present value";
    private static final String TEST_URI = "test:uri";
    private static final String TEST_PROPERTY = "test:property";
    private static final String PRESENT_VALUE = "present value";

    @Before
    public void init() {
        ConfigurationPropertiesStub configuration = new ConfigurationPropertiesStub();
        ConfigurationProperties.setInstance((ConfigurationProperties)configuration);
    }

    @Test
    public void testSimpleQuery() {
        Assert.assertTrue((boolean)QueryResultsMapCache.get().isEmpty());
        MutableAttributeValueSet values = new MutableAttributeValueSet(PRESENT_VALUE);
        StatementObjectUriCheck check = new StatementObjectUriCheck(TEST_URI, (AttributeValueSet)values);
        check.setConfiguration(SIMPLE_QUERY);
        NamedAccessObject ao = new NamedAccessObject(TEST_URI);
        OntModelImpl model = new OntModelImpl(OntModelSpec.OWL_MEM);
        model.add(ModelUtilitiesTestHelper.dataProperty(TEST_URI, TEST_PROPERTY, PRESENT_VALUE));
        ao.setModel((Model)model);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.DISPLAY);
        boolean result = SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testCacheNotCorruptedAfterCaching() throws IOException {
        try (QueryResultsMapCache cache = new QueryResultsMapCache();){
            Assert.assertTrue((boolean)QueryResultsMapCache.get().isEmpty());
            MutableAttributeValueSet values = new MutableAttributeValueSet(NOT_PRESENT_VALUE);
            StatementObjectUriCheck check = new StatementObjectUriCheck(TEST_URI, (AttributeValueSet)values);
            check.setConfiguration(SIMPLE_QUERY);
            NamedAccessObject ao = new NamedAccessObject(TEST_URI);
            OntModelImpl model = new OntModelImpl(OntModelSpec.OWL_MEM);
            model.add(ModelUtilitiesTestHelper.dataProperty(TEST_URI, TEST_PROPERTY, PRESENT_VALUE));
            ao.setModel((Model)model);
            TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.DISPLAY);
            Assert.assertFalse((boolean)SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null));
            Assert.assertEquals((long)1L, (long)QueryResultsMapCache.get().size());
            values.remove(NOT_PRESENT_VALUE);
            values.add(PRESENT_VALUE);
            Assert.assertTrue((boolean)SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null));
        }
    }

    @Test
    public void testCacheResultsNotCorruptedOnReuse() throws IOException {
        try (QueryResultsMapCache cache = new QueryResultsMapCache();){
            Assert.assertTrue((boolean)QueryResultsMapCache.get().isEmpty());
            MutableAttributeValueSet values = new MutableAttributeValueSet(PRESENT_VALUE);
            StatementObjectUriCheck check = new StatementObjectUriCheck(TEST_URI, (AttributeValueSet)values);
            check.setConfiguration(SIMPLE_QUERY);
            NamedAccessObject ao = new NamedAccessObject(TEST_URI);
            OntModelImpl model = new OntModelImpl(OntModelSpec.OWL_MEM);
            model.add(ModelUtilitiesTestHelper.dataProperty(TEST_URI, TEST_PROPERTY, PRESENT_VALUE));
            ao.setModel((Model)model);
            TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.DISPLAY);
            Assert.assertTrue((boolean)SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null));
            Assert.assertEquals((long)1L, (long)QueryResultsMapCache.get().size());
            values.remove(PRESENT_VALUE);
            values.add(NOT_PRESENT_VALUE);
            Assert.assertFalse((boolean)SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null));
            values.remove(NOT_PRESENT_VALUE);
            values.add(PRESENT_VALUE);
            Assert.assertTrue((boolean)SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain((Check)check, (AuthorizationRequest)ar, null));
        }
    }
}

