/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsUser;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsUserFactory;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class IsUserFactoryTest
extends AbstractTestClass {
    private static final String USER_URI = "http://userUri";
    private WebappDaoFactoryStub wdf;
    private UserAccountsDaoStub uaDao;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private IsUserFactory factory;
    private IdentifierBundle actualIds;
    private IdentifierBundle expectedIds;

    @Before
    public void setup() {
        this.uaDao = new UserAccountsDaoStub();
        this.wdf = new WebappDaoFactoryStub();
        this.wdf.setUserAccountsDao(this.uaDao);
        this.ctx = new ServletContextStub();
        new ModelAccessFactoryStub().get(this.ctx).setWebappDaoFactory(this.wdf);
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        this.factory = new IsUserFactory();
    }

    @Test
    public void notLoggedIn() {
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"empty bundle", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void loggedIn() {
        LoginStatusBean lsb = new LoginStatusBean(USER_URI, LoginStatusBean.AuthenticationSource.EXTERNAL);
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)lsb);
        UserAccount user = new UserAccount();
        user.setUri(USER_URI);
        this.uaDao.addUser(user);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{new IsUser(USER_URI)});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"user id", (Object)this.expectedIds, (Object)this.actualIds);
    }
}

