/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AccessAllowedClassesPolicyTemplateTest
extends PolicyTest {
    @Parameterized.Parameter(value=0)
    public AccessOperation ao;
    @Parameterized.Parameter(value=1)
    public AccessObjectType type;
    @Parameterized.Parameter(value=2)
    public String roleUri;
    @Parameterized.Parameter(value=3)
    public int rulesCount;
    @Parameterized.Parameter(value=4)
    public Set<Integer> attrCount;

    @Test
    public void testPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_class.n3");
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(ROLE_LIST);
        if (this.roleUri.equals("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM")) {
            PolicyTemplateController.createRoleDataSets((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
            roles.add("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        }
        EntityPolicyController.grantAccess((String)"test:entity", (AccessObjectType)this.type, (AccessOperation)this.ao, (String)this.roleUri, (String[])new String[0]);
        DynamicPolicy policy = null;
        String dataSet = this.loader.getDataSetUriByKey(new String[]{this.ao.toString(), this.type.toString(), this.roleUri});
        policy = this.loader.loadPolicyFromTemplateDataSet(dataSet);
        this.countRulesAndAttributes(policy, this.rulesCount, this.attrCount);
        Set values = this.loader.getDataSetValues(this.ao, this.type, this.roleUri);
        Assert.assertFalse((boolean)values.isEmpty());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> requests() {
        return Arrays.asList({AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC", 1, Collections.singleton(4)}, {AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, Collections.singleton(4)}, {AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", 1, Collections.singleton(4)}, {AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", 1, Collections.singleton(4)}, {AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 1, Collections.singleton(4)}, {AccessOperation.DISPLAY, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", 1, Collections.singleton(4)}, {AccessOperation.PUBLISH, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, Collections.singleton(4)}, {AccessOperation.PUBLISH, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", 1, Collections.singleton(4)}, {AccessOperation.PUBLISH, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", 1, Collections.singleton(4)}, {AccessOperation.PUBLISH, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 1, Collections.singleton(4)}, {AccessOperation.PUBLISH, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 1, Collections.singleton(4)}, {AccessOperation.UPDATE, AccessObjectType.CLASS, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", 1, Collections.singleton(4)});
    }
}

