/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AccessRelatedAllowedPropertiesPolicyTemplateTest
extends PolicyTest {
    @Parameterized.Parameter(value=0)
    public AccessOperation ao;
    @Parameterized.Parameter(value=1)
    public AccessObjectType type;
    @Parameterized.Parameter(value=2)
    public String roleUri;
    @Parameterized.Parameter(value=3)
    public int rulesCount;
    @Parameterized.Parameter(value=4)
    public Set<Integer> attrCount;

    @Test
    public void testPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_access_related_allowed_property.n3");
        EntityPolicyController.grantAccess((String)"test:entity", (AccessObjectType)this.type, (AccessOperation)this.ao, (String)this.roleUri, (String[])new String[0]);
        DynamicPolicy policy = null;
        String dataSet = this.loader.getDataSetUriByKey(new String[]{this.ao.toString(), this.type.toString(), this.roleUri});
        policy = this.loader.loadPolicyFromTemplateDataSet(dataSet);
        this.countRulesAndAttributes(policy, this.rulesCount, this.attrCount);
        Set values = this.loader.getDataSetValues(this.ao, this.type, this.roleUri);
        Assert.assertFalse((boolean)values.isEmpty());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> requests() {
        return Arrays.asList({AccessOperation.DISPLAY, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.PUBLISH, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.PUBLISH, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.PUBLISH, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)}, {AccessOperation.PUBLISH, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 2, AccessRelatedAllowedPropertiesPolicyTemplateTest.num(4)});
    }

    private static Set<Integer> num(int i) {
        return Collections.singleton(i);
    }
}

