/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.IndividualAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.NamedAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AllowDisplayIndividualPagePolicyTest
extends PolicyTest {
    public static final String POLICY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/policy_allow_display_individual_page.n3";

    @Test
    public void testLoadPolicy() {
        this.load(POLICY_PATH);
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/allow-display-individual-page/Policy";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        this.countRulesAndAttributes(policy, 1, Collections.singleton(2));
        IndividualAccessObject ao = new IndividualAccessObject("https://test-individual");
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.DISPLAY);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.ADD);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new NamedAccessObject("https://test-individual");
        ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.DISPLAY);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }
}

