/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class BasicPolicyTest
extends PolicyTest {
    public static final String BROKEN_POLICY_BROKEN_TEST = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken1.n3";
    public static final String BROKEN_POLICY_BROKEN_TYPE = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken2.n3";
    public static final String BROKEN_POLICY_BROKEN_TEST_ID = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken3.n3";
    public static final String BROKEN_POLICY_BROKEN_TYPE_ID = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken4.n3";
    public static final String BROKEN_POLICY_BROKEN_ATTRIBUTE_VALUES = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken5.n3";

    @Test
    public void testGetPolicyUris() {
        this.load("src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_valid.n3");
        Assert.assertTrue((!this.loader.getPolicyUris().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testValidPolicy() {
        this.load("src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_valid.n3");
        Assert.assertTrue((!this.loader.getPolicyUris().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testValidPolicyTemplate() {
        this.load("src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_valid_set.n3");
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/ValidTestSetPolicy";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)2L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        this.countRulesAndAttributes(policy, 1, Collections.singleton(2));
        policy = (DynamicPolicy)policies.iterator().next();
        this.countRulesAndAttributes(policy, 1, Collections.singleton(2));
    }

    @Test
    public void testBrokenTestId() {
        this.load(BROKEN_POLICY_BROKEN_TEST_ID);
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenPolicyBrokenTestTypeId";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testBrokenTypeId() {
        this.load(BROKEN_POLICY_BROKEN_TYPE_ID);
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenPolicyTypeId";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testBrokenTest() {
        this.load(BROKEN_POLICY_BROKEN_TEST);
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenPolicyBrokenTestType";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testBrokenType() {
        this.load(BROKEN_POLICY_BROKEN_TYPE);
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenPolicyType";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testBrokenAttributeValue() {
        this.load(BROKEN_POLICY_BROKEN_ATTRIBUTE_VALUES);
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenTestSetPolicy";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testBrokenPolicyTemplate() {
        this.load("src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken_set.n3");
        String uri = "https://vivoweb.org/ontology/vitro-application/auth/individual/BrokenTestSetPolicy";
        Set policies = this.loader.loadPolicies(uri);
        Assert.assertEquals((long)0L, (long)policies.size());
    }

    @Test
    public void testDuplicateTriplesInPolicies() {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        for (String entityPolicyPath : entityPolicies) {
            this.load(m2, entityPolicyPath);
            Model intersection = m1.intersection(m2);
            if (intersection.size() != 0L) {
                StringWriter sw = new StringWriter();
                m1.write((Writer)sw, "TTL");
                System.out.println(entityPolicyPath);
                System.out.println(sw.toString());
            }
            Assert.assertEquals((long)0L, (long)intersection.size());
            this.load(m1, entityPolicyPath);
            m2.removeAll();
        }
    }
}

