/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class EditablePagesPolicyTest
extends PolicyTest {
    public static final String RELATED_EDITABLE_PAGES_POLICY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/policy_related_editable_pages.n3";
    public static final String EDITABLE_PAGES_TEMPLATE_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_editable_pages.n3";

    @Test
    public void testLoadRelatedEditablePagesPolicy() {
        this.load(RELATED_EDITABLE_PAGES_POLICY_PATH);
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/edit-related-individual-pages/Policy";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        this.countRulesAndAttributes(policy, 2, new HashSet<Integer>(Arrays.asList(6)));
    }

    @Test
    public void testAdminEditablePagesPolicy() {
        this.load(EDITABLE_PAGES_TEMPLATE_PATH);
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/edit-individual-pages/AdminRoleDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)5L, (long)rule.getChecksCount());
        AccessOperation operation = AccessOperation.EDIT;
        ObjectPropertyStatementAccessObject object = new ObjectPropertyStatementAccessObject(null, "test://uri", AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, operation);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testCuratorEditablePagesPolicy() {
        this.load(EDITABLE_PAGES_TEMPLATE_PATH);
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/edit-individual-pages/CuratorRoleDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)5L, (long)rule.getChecksCount());
        AccessOperation operation = AccessOperation.EDIT;
        ObjectPropertyStatementAccessObject object = new ObjectPropertyStatementAccessObject(null, "test://uri", AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, operation);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testEditorEditablePagesPolicy() {
        this.load(EDITABLE_PAGES_TEMPLATE_PATH);
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/edit-individual-pages/EditorRoleDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)5L, (long)rule.getChecksCount());
        AccessOperation operation = AccessOperation.EDIT;
        ObjectPropertyStatementAccessObject object = new ObjectPropertyStatementAccessObject(null, "test://uri", AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, operation);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testCustomRole() {
        this.load(EDITABLE_PAGES_TEMPLATE_PATH);
        PolicyTemplateController.createRoleDataSets((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/edit-individual-pages/CustomRoleDataSet";
        Assert.assertTrue((dataSetUri != null ? 1 : 0) != 0);
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)5L, (long)rule.getChecksCount());
        AccessOperation operation = AccessOperation.EDIT;
        ObjectPropertyStatementAccessObject object = new ObjectPropertyStatementAccessObject(null, "test://uri", AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, operation);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }
}

