/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class EntityPolicyControllerTest
extends PolicyTest {
    @Test
    public void testGetGrantedRoles() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_class.n3");
        List<String> allowedRoles = Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR");
        EntityPolicyController.updateEntityDataSet((String)"test:newClass", (AccessObjectType)AccessObjectType.CLASS, (AccessOperation)AccessOperation.DISPLAY, allowedRoles, (List)ROLE_LIST);
        List roles = EntityPolicyController.getGrantedRoles((String)"test:newClass", (AccessOperation)AccessOperation.DISPLAY, (AccessObjectType)AccessObjectType.CLASS, (List)ROLE_LIST);
        Assert.assertEquals((long)2L, (long)roles.size());
        roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR");
    }

    @Test
    public void testPolicyDataSetModification() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_class.n3");
        EntityPolicyController.grantAccess((String)"test:newClass", (AccessObjectType)AccessObjectType.CLASS, (AccessOperation)AccessOperation.DISPLAY, (String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", (String[])new String[0]);
        EntityPolicyController.grantAccess((String)"test:newClass2", (AccessObjectType)AccessObjectType.CLASS, (AccessOperation)AccessOperation.DISPLAY, (String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", (String[])new String[0]);
        List roles = EntityPolicyController.getGrantedRoles((String)"test:newClass", (AccessOperation)AccessOperation.DISPLAY, (AccessObjectType)AccessObjectType.CLASS, (List)ROLE_LIST);
        Assert.assertEquals((long)1L, (long)roles.size());
        roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        EntityPolicyController.updateEntityDataSet((String)"test:newClass", (AccessObjectType)AccessObjectType.CLASS, (AccessOperation)AccessOperation.DISPLAY, Collections.emptyList(), (List)ROLE_LIST);
        roles = EntityPolicyController.getGrantedRoles((String)"test:newClass", (AccessOperation)AccessOperation.DISPLAY, (AccessObjectType)AccessObjectType.CLASS, (List)ROLE_LIST);
        Assert.assertEquals((long)0L, (long)roles.size());
    }
}

