/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class HomeMenuItemsRestrictionPolicyTest
extends PolicyTest {
    public static final String MENU_ITEMS_POLICY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/policy_menu_items_editing.n3";

    @Test
    public void testHomeMenuItemsRestrictionPolicy() {
        this.load(MENU_ITEMS_POLICY_PATH);
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/restrict-home-menu-items-editing/Policy";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertEquals((long)9000L, (long)policy.getPriority());
        Assert.assertTrue((policy.getRules().size() > 0 ? 1 : 0) != 0);
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)false, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        ObjectPropertyStatementAccessObject ao = new ObjectPropertyStatementAccessObject(null, null, new Property("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#HomeMenuItem"), "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasElement");
        SimpleAuthorizationRequest ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.EDIT);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.ADD);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }
}

