/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class NonModifiableStatementsPolicyTest
extends PolicyTest {
    private static final String VALID = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Valid";
    private static final String MOD_TIME = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime";
    public static final String NOT_MODIFIABLE_STATEMENTS_POLICY_PATH = "template_not_modifiable_statements";

    @Test
    public void testNonModifiableStatementsPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_not_modifiable_statements.n3");
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/non-modifiable-statements/PolicyTemplate";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertEquals((long)8000L, (long)policy.getPriority());
        Assert.assertEquals((long)5L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)false, (Object)rule.isAllowMatched());
        for (AccessRule irule : policy.getRules()) {
            Assert.assertEquals((long)3L, (long)irule.getChecksCount());
        }
        ObjectPropertyStatementAccessObject ao = new ObjectPropertyStatementAccessObject(null, VALID, null, null);
        SimpleAuthorizationRequest ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new ObjectPropertyStatementAccessObject(null, MOD_TIME, null, null);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new ObjectPropertyStatementAccessObject(null, null, new Property(VALID), null);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new ObjectPropertyStatementAccessObject(null, null, new Property(MOD_TIME), null);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new ObjectPropertyStatementAccessObject(null, null, null, VALID);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new ObjectPropertyStatementAccessObject(null, null, null, MOD_TIME);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new DataPropertyStatementAccessObject(null, VALID, AccessObject.SOME_URI, AccessObject.SOME_LITERAL);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new DataPropertyStatementAccessObject(null, MOD_TIME, AccessObject.SOME_URI, AccessObject.SOME_LITERAL);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new DataPropertyStatementAccessObject(null, AccessObject.SOME_URI, VALID, AccessObject.SOME_LITERAL);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ao = new DataPropertyStatementAccessObject(null, AccessObject.SOME_URI, MOD_TIME, AccessObject.SOME_LITERAL);
        ar = new SimpleAuthorizationRequest((AccessObject)ao, AccessOperation.DROP);
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }
}

