/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Before;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class PolicyHelper_AuthorizationRequestTest {
    private ServletContextStub ctx;
    private HttpServletRequestStub req;
    private AccessObject nullAr = null;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        PolicyStore.getInstance().clear();
        HttpSessionStub session = new HttpSessionStub();
        session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(session);
    }

    private void createPolicy(AccessObject ... authorizedActions) {
        PolicyStore.getInstance().add((Policy)new MySimplePolicy(authorizedActions));
    }

    private static class MySimplePolicy
    implements Policy {
        private final Set<AccessObject> authorizedActions;

        public MySimplePolicy(AccessObject ... authorizedActions) {
            this.authorizedActions = new HashSet<AccessObject>(Arrays.asList(authorizedActions));
        }

        public PolicyDecision decide(AuthorizationRequest ar) {
            AccessObject whatToAuth = ar.getAccessObject();
            for (AccessObject authorized : this.authorizedActions) {
                if (!authorized.getClass().equals(whatToAuth.getClass())) continue;
                return new BasicPolicyDecision(DecisionResult.AUTHORIZED, "matched " + authorized.getClass().getSimpleName());
            }
            return new BasicPolicyDecision(DecisionResult.INCONCLUSIVE, "nope");
        }
    }

    public static class Action3
    extends AccessObject {
        public AccessObjectType getType() {
            return null;
        }
    }

    public static class Action2
    extends AccessObject {
        public AccessObjectType getType() {
            return null;
        }
    }

    public static class Action1
    extends AccessObject {
        public AccessObjectType getType() {
            return null;
        }
    }
}

