/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class PolicyHelper_StatementsTest
extends AbstractTestClass {
    private static final String APPROVED_SUBJECT_URI = "test://approvedSubjectUri";
    private static final String APPROVED_PREDICATE_URI = "test://approvedPredicateUri";
    private static final String UNAPPROVED_PREDICATE_URI = "test://bogusPredicateUri";
    private static final String APPROVED_OBJECT_URI = "test://approvedObjectUri";
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private OntModel ontModel;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        PolicyStore.getInstance().clear();
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        PolicyHelper_StatementsTest.setLoggerLevel(PolicyStore.class, Level.WARN);
        PolicyStore.getInstance().add((Policy)new MySimplePolicy());
    }

    @Test
    public void addNullStatement() {
        Assert.assertEquals((String)"null statement", (Object)false, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, null, (OntModel)this.ontModel));
    }

    @Test
    public void addStatementWithNullRequest() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"null request", (Object)false, (Object)PolicyHelper.isAuthorizedToAdd(null, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void addStatementToNullModel() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, (Statement)stmt, null));
    }

    @Test
    public void addAuthorizedDataStatement() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"authorized", (Object)true, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void addAuthorizedObjectStatement() {
        Statement stmt = this.objectStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI, APPROVED_OBJECT_URI);
        Assert.assertEquals((String)"authorized", (Object)true, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void addUnauthorizedDataStatement() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, UNAPPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"not authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void addUnauthorizedObjectStatement() {
        Statement stmt = this.objectStatement(APPROVED_SUBJECT_URI, UNAPPROVED_PREDICATE_URI, APPROVED_OBJECT_URI);
        Assert.assertEquals((String)"not authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToAdd((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void dropNullStatement() {
        Assert.assertEquals((String)"null statement", (Object)false, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)null, (OntModel)this.ontModel));
    }

    @Test
    public void dropStatementWithNullRequest() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"null request", (Object)false, (Object)PolicyHelper.isAuthorizedToDrop(null, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void dropStatementFromNullModel() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)stmt, null));
    }

    @Test
    public void dropAuthorizedDataStatement() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"authorized", (Object)true, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void dropAuthorizedObjectStatement() {
        Statement stmt = this.objectStatement(APPROVED_SUBJECT_URI, APPROVED_PREDICATE_URI, APPROVED_OBJECT_URI);
        Assert.assertEquals((String)"authorized", (Object)true, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void dropUnauthorizedDataStatement() {
        Statement stmt = this.dataStatement(APPROVED_SUBJECT_URI, UNAPPROVED_PREDICATE_URI);
        Assert.assertEquals((String)"not authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    @Test
    public void dropUnauthorizedObjectStatement() {
        Statement stmt = this.objectStatement(APPROVED_SUBJECT_URI, UNAPPROVED_PREDICATE_URI, APPROVED_OBJECT_URI);
        Assert.assertEquals((String)"not authorized", (Object)false, (Object)PolicyHelper.isAuthorizedToDrop((HttpServletRequest)this.req, (Statement)stmt, (OntModel)this.ontModel));
    }

    private Statement dataStatement(String subjectUri, String predicateUri) {
        Resource subject = this.ontModel.createResource(subjectUri);
        Property predicate = this.ontModel.createProperty(predicateUri);
        return this.ontModel.createStatement(subject, predicate, "whoCares?");
    }

    private Statement objectStatement(String subjectUri, String predicateUri, String objectUri) {
        Resource subject = this.ontModel.createResource(subjectUri);
        Resource object = this.ontModel.createResource(objectUri);
        Property predicate = this.ontModel.createProperty(predicateUri);
        return this.ontModel.createStatement(subject, predicate, (RDFNode)object);
    }

    private static class MySimplePolicy
    implements Policy {
        private MySimplePolicy() {
        }

        public PolicyDecision decide(AuthorizationRequest ar) {
            AccessObject whatToAuth = ar.getAccessObject();
            if (whatToAuth instanceof DataPropertyStatementAccessObject) {
                return this.isAuthorized((DataPropertyStatementAccessObject)whatToAuth);
            }
            if (whatToAuth instanceof ObjectPropertyStatementAccessObject) {
                return this.isAuthorized((ObjectPropertyStatementAccessObject)whatToAuth);
            }
            return this.inconclusive();
        }

        private PolicyDecision isAuthorized(DataPropertyStatementAccessObject whatToAuth) {
            if (PolicyHelper_StatementsTest.APPROVED_SUBJECT_URI.equals(whatToAuth.getStatementSubject()) && PolicyHelper_StatementsTest.APPROVED_PREDICATE_URI.equals(whatToAuth.getStatementPredicateUri())) {
                return this.authorized();
            }
            return this.inconclusive();
        }

        private PolicyDecision isAuthorized(ObjectPropertyStatementAccessObject whatToAuth) {
            if (PolicyHelper_StatementsTest.APPROVED_SUBJECT_URI.equals(whatToAuth.getStatementSubject()) && PolicyHelper_StatementsTest.APPROVED_PREDICATE_URI.equals(whatToAuth.getStatementPredicateUri()) && PolicyHelper_StatementsTest.APPROVED_OBJECT_URI.equals(whatToAuth.getStatementObject())) {
                return this.authorized();
            }
            return this.inconclusive();
        }

        private PolicyDecision authorized() {
            return new BasicPolicyDecision(DecisionResult.AUTHORIZED, "");
        }

        private PolicyDecision inconclusive() {
            return new BasicPolicyDecision(DecisionResult.INCONCLUSIVE, "");
        }
    }
}

