/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class PolicyLoaderTest
extends PolicyTest {
    private static final String PREFIX = "https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/";
    public static final String DATA_SET = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/data_set_templates.n3";

    @Test
    public void getRoleDataSetTemplatesTest() {
        this.load(DATA_SET);
        Map templates = PolicyLoader.getInstance().getRoleDataSetTemplates();
        Assert.assertEquals((long)2L, (long)templates.size());
        Assert.assertTrue((boolean)templates.containsKey("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate1"));
        Assert.assertEquals((Object)"https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/PolicyTemplate", templates.get("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate1"));
        Assert.assertTrue((boolean)templates.containsKey("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate2"));
        Assert.assertEquals((Object)"https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/PolicyTemplate", templates.get("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate2"));
    }

    @Test
    public void getRoleDataSetKeyTemplateTest() {
        this.load(DATA_SET);
        List keys = PolicyLoader.getInstance().getDataSetKeysFromTemplate("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate1");
        Assert.assertEquals((long)2L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("https://vivoweb.org/ontology/vitro-application/auth/individual/NamedObject"));
        Assert.assertTrue((boolean)keys.contains("https://vivoweb.org/ontology/vitro-application/auth/individual/ExecuteOperation"));
    }

    @Test
    public void getRoleDataSetDraftKeyTemplateTest() {
        this.load(DATA_SET);
        List keys = PolicyLoader.getInstance().getDataSetKeyTemplatesFromTemplate("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate1");
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("https://vivoweb.org/ontology/vitro-application/auth/individual/SubjectRole"));
    }

    @Test
    public void getDataSetUriByKeyTest() {
        this.load(DATA_SET);
        String uri = PolicyLoader.getInstance().getDataSetUriByKey(new String[]{AccessObjectType.NAMED_OBJECT.toString(), AccessOperation.EXECUTE.toString(), "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"});
        Assert.assertEquals((Object)"https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/PublicDataSet", (Object)uri);
    }

    @Test
    public void getRoleDataSetValuesTemplateTest() {
        this.load(DATA_SET);
        List values = PolicyLoader.getInstance().getDataSetValuesFromTemplate("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/RoleDataSetTemplate1");
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals(values.get(0), (Object)"https://vivoweb.org/ontology/vitro-application/auth/individual/PublicRoleValueSet");
    }

    @Test
    public void getDataSetKeyTest() {
        this.load(DATA_SET);
        AttributeValueKey expectedKey = new AttributeValueKey();
        expectedKey.setOperation(AccessOperation.EXECUTE);
        expectedKey.setRole("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        expectedKey.setObjectType(AccessObjectType.NAMED_OBJECT);
        AttributeValueKey compositeKey = PolicyLoader.getInstance().getDataSetKey("https://vivoweb.org/ontology/vitro-application/auth/individual/template/test-data-set-templates/PublicDataSet");
        Assert.assertEquals((Object)expectedKey, (Object)compositeKey);
    }

    @Test
    public void getSubjectRoleValuePatternTest() {
        List patterns = this.loader.getSubjectRoleValuePattern("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        Assert.assertTrue((boolean)patterns.isEmpty());
        Model tmpModel = ModelFactory.createDefaultModel();
        PolicyTemplateController.createSubjectRoleUri((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", (Model)tmpModel);
        this.accessControlModel.add(tmpModel);
        this.configurationDataSet.replaceNamedModel("http://vitro.mannlib.cornell.edu/default/access-control", this.accessControlModel);
        patterns = this.loader.getSubjectRoleValuePattern("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        Assert.assertTrue((!patterns.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)patterns.size());
    }

    @Test
    public void testLoadPolicyWithValues() {
        this.load("src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/policy_values.n3");
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/policy-values-test/Policy";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)100L, (long)policy.getPriority());
        this.countRulesAndAttributes(policy, 1, Collections.singleton(1));
    }
}

